/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util.string_converter.args;

import net.kapitencraft.kap_lib.stream.UnaryBiOperator;
import net.kapitencraft.kap_lib.util.string_converter.args.CalculationArgument;
import net.kapitencraft.kap_lib.util.string_converter.converter.TextToNumConverter;

public class MathArgument<T extends Number>
implements CalculationArgument<T> {
    private final String name;
    private final UnaryBiOperator<T> MULTIPLY = (value1, value2) -> (Double)value1 * (Double)value2;
    private final UnaryBiOperator<T> SQUARE = (value1, value2) -> Math.pow((Double)value1, (Double)value2);
    private final UnaryBiOperator<T> DIVIDE = (value1, value2) -> (Double)value1 / (Double)value2;
    private final UnaryBiOperator<T> ADD = (value1, value2) -> (Double)value1 + (Double)value2;
    private final UnaryBiOperator<T> REDUCE = (value1, value2) -> (Double)value1 - (Double)value2;
    private final UnaryBiOperator<T> MODULO = (value1, value2) -> (Integer)value1 % (Integer)value2;

    public MathArgument(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public T apply(T a, T b) {
        return (T)(switch (this.name) {
            case "*" -> (Number)this.MULTIPLY.apply(a, b);
            case "/" -> (Number)this.DIVIDE.apply(a, b);
            case "+" -> (Number)this.ADD.apply(a, b);
            case "-" -> (Number)this.REDUCE.apply(a, b);
            case "%" -> (Number)this.MODULO.apply(a, b);
            case "^" -> (Number)this.SQUARE.apply(a, b);
            default -> 0;
        });
    }

    @Override
    public boolean isPreferred() {
        return TextToNumConverter.PREFERRED_ARGS.contains(this.name);
    }
}

