/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import java.util.List;
import net.kapitencraft.kap_lib.client.overlay.OverlayManager;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.holder.MultiLineOverlay;
import net.kapitencraft.kap_lib.client.overlay.holder.SimpleOverlay;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.custom.Overlays;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class OverlaysRegister {
    public static void register(OverlayManager manager) {
        manager.createRenderer(Overlays.STATS, properties -> new MultiLineOverlay((Component)Component.translatable((String)"overlay.stats"), (OverlayProperties)properties, -10.0f, List.of(player -> Component.translatable((String)"overlay.stats.protection", (Object[])new Object[]{OverlaysRegister.getDamageProtection((LivingEntity)player)}).withStyle(ChatFormatting.DARK_BLUE), player -> Component.translatable((String)"overlay.stats.ehp", (Object[])new Object[]{MathHelper.defRound((double)(player.getHealth() * 100.0f) / (100.0 - OverlaysRegister.getDamageProtection((LivingEntity)player)))}).withStyle(ChatFormatting.DARK_AQUA), player -> Component.translatable((String)"overlay.stats.speed", (Object[])new Object[]{OverlaysRegister.cancelGravityMovement((LivingEntity)player)}).withStyle(ChatFormatting.YELLOW))));
        manager.createRenderer(Overlays.MANA, properties -> new SimpleOverlay((Component)Component.translatable((String)"overlay.mana"), (OverlayProperties)properties, player -> Component.translatable((String)"overlay.mana.display", (Object[])new Object[]{MathHelper.shortRound(player.getAttributeValue(ExtraAttributes.MANA)), MathHelper.shortRound(player.getPersistentData().getDouble("overflowMana")), player.getAttributeValue(ExtraAttributes.MAX_MANA), MathHelper.defRound(player.getPersistentData().getDouble("manaRegen") * 20.0)}).withStyle(ChatFormatting.BLUE)));
    }

    private static double getDamageProtection(LivingEntity living) {
        return MathHelper.defRound(100.0f - MathHelper.calculateDamage(100.0f, living.getAttributeValue(Attributes.ARMOR), living.getAttributeValue(Attributes.ARMOR_TOUGHNESS)));
    }

    private static double cancelGravityMovement(LivingEntity living) {
        Vec3 delta = living.getDeltaMovement();
        if (living.onGround()) {
            delta = delta.with(Direction.Axis.Y, 0.0);
        }
        return MathHelper.defRound(delta.length() * 20.0);
    }
}

