/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.core;

import java.util.function.BiConsumer;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleSpawnSink
implements BiConsumer<ParticleOptions, Vec3> {
    private final ParticleEngine engine;
    private final ParticleAnimator animator;
    public final RandomSource random;

    public ParticleSpawnSink(ParticleAnimator animator) {
        this.engine = Minecraft.getInstance().particleEngine;
        this.animator = animator;
        this.random = RandomSource.create();
    }

    public void accept(ParticleOptions particleConfig, double x, double y, double z) {
        Particle particle = this.engine.createParticle(particleConfig, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (particle != null) {
            particle.setPos(x, y, z);
            particle.xd = 0.0;
            particle.yd = 0.0;
            particle.zd = 0.0;
            this.animator.addParticle(particle);
        }
    }

    @Override
    public void accept(ParticleOptions particleConfig, Vec3 pos) {
        this.accept(particleConfig, pos.x, pos.y, pos.z);
    }
}

