/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LineSpawner
extends VisibleSpawner {
    private final PositionTarget start;
    private final PositionTarget end;
    private final float spacing;

    public LineSpawner(ParticleOptions options, PositionTarget start, PositionTarget end, float spacing) {
        super(options);
        this.start = start;
        this.end = end;
        this.spacing = spacing;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        List<Vec3> positions = MathHelper.makeLine(this.start.get(), this.end.get(), this.spacing);
        positions.forEach(v -> sink.accept(this.particle, (Vec3)v));
    }

    @NotNull
    public Type getType() {
        return SpawnerTypes.LINE.get();
    }

    public String toString() {
        return "LineSpawner from " + String.valueOf(this.start) + " to " + String.valueOf(this.end) + ", spacing = " + this.spacing + ", particle = " + String.valueOf(this.particle);
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private PositionTarget start;
        private PositionTarget end;
        private float spacing;

        public Builder start(PositionTarget start) {
            this.start = start;
            return this;
        }

        public Builder end(PositionTarget end) {
            this.end = end;
            return this;
        }

        public Builder spacing(float spacing) {
            this.spacing = spacing;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new LineSpawner(this.particle, this.start, this.end, this.spacing);
        }
    }

    public static class Type
    implements Spawner.Type<LineSpawner> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, LineSpawner> STREAM_CODEC = StreamCodec.composite((StreamCodec)ParticleTypes.STREAM_CODEC, s -> s.particle, PositionTarget.STREAM_CODEC, s -> s.start, PositionTarget.STREAM_CODEC, s -> s.end, (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.spacing), LineSpawner::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, LineSpawner> codec() {
            return STREAM_CODEC;
        }
    }
}

