/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.util.pos_target;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.util.pos_target.AbsolutePositionTarget;
import net.kapitencraft.kap_lib.client.util.pos_target.EntityBBPositionTarget;
import net.kapitencraft.kap_lib.client.util.pos_target.EntityPositionTarget;
import net.kapitencraft.kap_lib.client.util.pos_target.RelativePositionTarget;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;

public interface PositionTarget
extends Supplier<Vec3> {
    public static final StreamCodec<? super RegistryFriendlyByteBuf, PositionTarget> STREAM_CODEC = StreamCodec.of(Types::toNw, PositionTarget::fromNw);

    public static PositionTarget fromNw(RegistryFriendlyByteBuf buf) {
        Types t = Types.values()[buf.readInt()];
        return (PositionTarget)t.type.codec().decode((Object)buf);
    }

    public static PositionTarget fixed(Vec3 pos) {
        return new AbsolutePositionTarget(pos);
    }

    public static PositionTarget relative(PositionTarget pos, Vec3 offset) {
        return new RelativePositionTarget(pos, offset);
    }

    public static PositionTarget entity(Entity entity) {
        return new EntityPositionTarget(entity.getId(), EntityAnchorArgument.Anchor.FEET);
    }

    public static PositionTarget entityEyes(Entity entity) {
        return new EntityPositionTarget(entity.getId(), EntityAnchorArgument.Anchor.EYES);
    }

    public static PositionTarget entityBB(Entity entity) {
        return new EntityBBPositionTarget(entity.getId());
    }

    @Override
    public Vec3 get();

    public Types getType();

    public static enum Types implements IExtensibleEnum
    {
        ENTITY(EntityPositionTarget.Type::new),
        ENTITY_BB(EntityBBPositionTarget.Type::new),
        POS(AbsolutePositionTarget.Type::new),
        RELATIVE(RelativePositionTarget.Type::new);

        private final Type<? extends PositionTarget> type;

        private Types(Supplier<Type<? extends PositionTarget>> typeSupplier) {
            this.type = typeSupplier.get();
        }

        private static <T extends PositionTarget> void toNw(RegistryFriendlyByteBuf buf, T val) {
            Types types = val.getType();
            buf.writeInt(types.ordinal());
            types.type.codec().encode((Object)buf, val);
        }
    }

    public static interface Type<T extends PositionTarget> {
        public StreamCodec<? super RegistryFriendlyByteBuf, T> codec();
    }
}

