/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.BooleanElement;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.Element;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.ListElement;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class MultiElementSelectorElement<T>
extends ListElement {
    private final Predicate<T> statusMapper;
    private final Function<T, Component> nameMapper;
    private final BiConsumer<T, Boolean> onChange;

    public MultiElementSelectorElement(@Nullable ListElement listElement, DropDownMenu menu, Component component, Collection<T> elements, Predicate<T> statusMapper, Function<T, Component> nameMapper, BiConsumer<T, Boolean> onChange) {
        super(listElement, menu, component);
        this.statusMapper = statusMapper;
        this.nameMapper = nameMapper;
        this.onChange = onChange;
        elements.forEach(t -> this.addElement(new SelectorElement(this, menu, t)));
    }

    public static <T> Builder<T> builder(Class<T> ignoredIdentificationClass) {
        return new Builder();
    }

    public static class Builder<T>
    extends Element.Builder<MultiElementSelectorElement<T>, Builder<T>> {
        private Predicate<T> statusMapper;
        private Function<T, Component> nameMapper;
        private BiConsumer<T, Boolean> onChange;
        private Collection<T> elements;

        public Builder<T> setOnChange(BiConsumer<T, Boolean> onChange) {
            this.onChange = onChange;
            return this;
        }

        public Builder<T> setNameMapper(Function<T, Component> nameMapper) {
            this.nameMapper = nameMapper;
            return this;
        }

        public Builder<T> setStatusMapper(Predicate<T> statusMapper) {
            this.statusMapper = statusMapper;
            return this;
        }

        public Builder<T> setElements(Collection<T> elements) {
            this.elements = elements;
            return this;
        }

        @Override
        public MultiElementSelectorElement<T> build(ListElement element, DropDownMenu menu) {
            return new MultiElementSelectorElement<T>(element, menu, this.name, this.elements, this.statusMapper, this.nameMapper, this.onChange);
        }
    }

    private class SelectorElement
    extends BooleanElement {
        private final T value;

        protected SelectorElement(ListElement parent, DropDownMenu menu, T value) {
            super(parent, menu, MultiElementSelectorElement.this.nameMapper.apply(value), b -> net$kapitencraft$kap_lib$client$widget$menu$drop_down$elements$MultiElementSelectorElement$this.onChange.accept(value, (Boolean)b));
            this.value = value;
        }

        @Override
        public boolean selected() {
            return MultiElementSelectorElement.this.statusMapper.test(this.value);
        }
    }
}

