/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.io.network.S2C.capability.CooldownStartedPacket;
import net.kapitencraft.kap_lib.io.network.S2C.capability.SyncCooldownsToPlayerPacket;
import net.kapitencraft.kap_lib.util.IntegerReference;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Cooldowns {
    public static final EntityCapability<Cooldowns, Void> CAPABILITY = EntityCapability.createVoid((ResourceLocation)KapLibMod.res("cooldowns"), Cooldowns.class);
    private final LivingEntity entity;
    private final Map<Cooldown, IntegerReference> active = new HashMap<Cooldown, IntegerReference>();

    public Cooldowns(LivingEntity entity) {
        this.entity = entity;
    }

    public boolean isActive(Cooldown cooldown) {
        return this.active.containsKey(cooldown);
    }

    public void tick() {
        ArrayList toRemove = new ArrayList();
        this.active.forEach((cooldown, integerReference) -> {
            integerReference.decrease();
            if (integerReference.getIntValue() <= 0) {
                toRemove.add(cooldown);
            }
        });
        toRemove.forEach(c -> {
            c.onDone(this.entity);
            this.active.remove(c);
        });
    }

    public void applyCooldown(Cooldown cooldown, boolean reduceWithTime) {
        int time = cooldown.getCooldownTime(this.entity, reduceWithTime);
        if (time > 0) {
            this.active.put(cooldown, IntegerReference.create(time));
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new CooldownStartedPacket(cooldown, time, this.entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public int getCooldownTime(Cooldown cooldown) {
        IntegerReference reference = this.active.get(cooldown);
        return reference == null ? 0 : reference.getIntValue();
    }

    public Map<Cooldown, Integer> getData() {
        HashMap<Cooldown, Integer> map = new HashMap<Cooldown, Integer>();
        this.active.forEach((cooldown, integerReference) -> map.put((Cooldown)cooldown, integerReference.getIntValue()));
        return map;
    }

    public void loadData(Map<Cooldown, Integer> map) {
        map.forEach((cooldown, integer) -> this.active.put((Cooldown)cooldown, IntegerReference.create(integer)));
    }

    public static Cooldowns get(LivingEntity living) {
        return Objects.requireNonNull((Cooldowns)living.getCapability(CAPABILITY), "unable to get capability");
    }

    public static void send(ServerPlayer sP) {
        Cooldowns cooldown = Cooldowns.get((LivingEntity)sP);
        PacketDistributor.sendToPlayer((ServerPlayer)sP, (CustomPacketPayload)new SyncCooldownsToPlayerPacket(sP.getId(), cooldown.getData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setCooldownTime(Cooldown cooldown, int duration) {
        this.active.put(cooldown, IntegerReference.create(duration));
    }
}

