/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.crafting.serializers;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.collection.StreamEntry;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorRecipe
extends CustomRecipe {
    private final Ingredient material;
    private final Map<ArmorType, CraftingRecipe> all;
    private final Map<ArmorType, ItemStack> entries;
    private final String group;

    public ArmorRecipe(Ingredient material, Map<ArmorType, ItemStack> all, String group) {
        super(CraftingBookCategory.EQUIPMENT);
        this.material = material;
        this.group = group;
        this.entries = all;
        this.all = MapStream.of(all).biMap((armorType, stack) -> new StreamEntry<ArmorType, CraftingRecipe>((ArmorType)((Object)armorType), this.create((ArmorType)((Object)armorType), (ItemStack)stack))).toMap();
    }

    private CraftingRecipe create(ArmorType type, ItemStack stack) {
        ShapedRecipePattern pattern = type.makePattern(this.material);
        return new ShapedRecipe(this.getGroup(), this.category(), pattern, stack);
    }

    public boolean matches(@NotNull CraftingInput container, @NotNull Level level) {
        return this.all.values().stream().anyMatch(recipe -> recipe.matches((RecipeInput)container, level));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput pContainer, @NotNull HolderLookup.Provider pRegistryAccess) {
        for (CraftingRecipe recipe : this.all.values()) {
            if (!recipe.matches((RecipeInput)pContainer, null)) continue;
            return recipe.assemble((RecipeInput)pContainer, pRegistryAccess);
        }
        return ItemStack.EMPTY;
    }

    public Map<ArmorType, CraftingRecipe> getAll() {
        return this.all;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i == 3 && j == 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ExtraRecipeSerializers.ARMOR.value();
    }

    private static ArmorRecipe fromCodec(Ingredient ingredient, Map<ArmorType, ItemStack> map, Optional<String> s) {
        return new ArmorRecipe(ingredient, map, s.orElse(null));
    }

    public static enum ArmorType implements StringRepresentable
    {
        HELMET("helmet", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), true)),
        CHESTPLATE("chestplate", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), false)),
        LEGGINGS("leggings", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), false)),
        BOOTS("boots", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), true));

        public static final StringRepresentable.EnumCodec<ArmorType> CODEC;
        private final String name;
        private final boolean small;
        private final boolean[][] data;

        public static ArmorType fromEquipmentSlot(ArmorItem.Type type) {
            return ArmorType.valueOf(type.getName().toUpperCase());
        }

        public static ArmorType get(String name) {
            return (ArmorType)CODEC.byName(name, (Enum)HELMET);
        }

        private static boolean[][] of(List<Boolean> list, boolean small) {
            int height = small ? 2 : 3;
            boolean[][] map = new boolean[3][height];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < height; ++j) {
                    map[i][j] = list.get(i + j * 3);
                }
            }
            return map;
        }

        private ArmorType(String name, boolean[][] data) {
            this.name = name;
            this.small = data[0].length == 2;
            this.data = data;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public ShapedRecipePattern makePattern(Ingredient main) {
            NonNullList list = NonNullList.withSize((int)(this.small ? 6 : 9), (Object)Ingredient.EMPTY);
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < (this.small ? 2 : 3); ++y) {
                    if (!this.data[x][y]) continue;
                    list.set(x + y * 3, (Object)main);
                }
            }
            return new ShapedRecipePattern(3, this.small ? 2 : 3, list, Optional.empty());
        }

        static {
            CODEC = StringRepresentable.fromEnum(ArmorType::values);
        }
    }

    public static class Serializer
    implements RecipeSerializer<ArmorRecipe> {
        private static final MapCodec<ArmorRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("material").forGetter(r -> r.material), (App)Codec.either((Codec)Codec.STRING, (Codec)ResourceLocation.CODEC.listOf()).flatXmap(Serializer::decodeResults, Serializer::encodeResults).fieldOf("results").forGetter(r -> r.entries), (App)Codec.STRING.optionalFieldOf("group").forGetter(r -> Optional.ofNullable(r.group))).apply((Applicative)i, ArmorRecipe::fromCodec));
        private static final StreamCodec<RegistryFriendlyByteBuf, ArmorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static DataResult<? extends Either<String, List<ResourceLocation>>> encodeResults(Map<ArmorType, ItemStack> map) {
            String merged = null;
            ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
            for (Map.Entry<ArmorType, ItemStack> entry : map.entrySet()) {
                ItemStack stack = entry.getValue();
                if (!BuiltInRegistries.ITEM.containsValue((Object)stack.getItem())) {
                    return DataResult.error(() -> "unable to find item '" + String.valueOf(stack.getItem()) + "' in the registry");
                }
                ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                String val = location.getPath();
                if (!val.endsWith("_" + entry.getKey().getSerializedName())) {
                    merged = null;
                } else {
                    String element = val.substring(0, val.length() - entry.getKey().getSerializedName().length() - 1);
                    if (merged == null) {
                        merged = element;
                    } else if (!merged.equals(element)) {
                        merged = "";
                    }
                }
                locations.add(location);
            }
            if (merged != null && !merged.isEmpty()) {
                return DataResult.success((Object)Either.left((Object)merged));
            }
            return DataResult.success((Object)Either.right(locations));
        }

        private static DataResult<Map<ArmorType, ItemStack>> decodeResults(Either<String, List<ResourceLocation>> stringListEither) {
            ArmorType[] values = ArmorType.values();
            List locations = (List)stringListEither.map(string -> Arrays.stream(values).map(ArmorType::getSerializedName).map(s -> TextHelper.mergeRegister(string, s)).map(ResourceLocation::parse).toList(), Function.identity());
            HashMap<ArmorType, ItemStack> stackMap = new HashMap<ArmorType, ItemStack>();
            for (int i1 = 0; i1 < locations.size(); ++i1) {
                ResourceLocation name = (ResourceLocation)locations.get(i1);
                if (!BuiltInRegistries.ITEM.containsKey(name)) {
                    return DataResult.error(() -> "unknown item '" + String.valueOf(name) + "'");
                }
                stackMap.put(values[i1], new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(name)));
            }
            return DataResult.success((Object)ImmutableMap.copyOf(stackMap));
        }

        @NotNull
        public static ArmorRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            Ingredient material = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            List<String> items = CollectionHelper.create(4, () -> ((RegistryFriendlyByteBuf)buf).readUtf());
            List<ItemStack> results = items.stream().filter(s -> !Objects.equals(s, "")).map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).map(ItemStack::new).toList();
            List<ArmorType> types = Arrays.stream(ArmorType.values()).toList();
            Map<ArmorType, ItemStack> resultMap = MapStream.create(types, results).toMap();
            return new ArmorRecipe(material, resultMap, group);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, ArmorRecipe recipe) {
            buf.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.material);
            recipe.all.values().stream().map(shapedRecipe -> shapedRecipe.getResultItem(null)).map(ItemStack::getItem).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(ResourceLocation::toString).forEach(arg_0 -> ((RegistryFriendlyByteBuf)buf).writeUtf(arg_0));
            MiscHelper.repeat(4 - recipe.all.size(), integer -> buf.writeUtf(""));
            buf.writeEnum((Enum)recipe.category());
        }

        public MapCodec<ArmorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ArmorRecipe> streamCodec() {
            return null;
        }
    }
}

