/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.crafting.serializers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class UpgradeItemRecipe
extends CustomRecipe {
    private final Ingredient source;
    private final Ingredient upgradeItem;
    private final ItemStack result;
    private final String group;
    private final CraftType type;

    public UpgradeItemRecipe(CraftingBookCategory bookCategory, Ingredient source, Ingredient upgradeItem, ItemStack result, String group, CraftType type) {
        super(bookCategory);
        this.source = source;
        this.upgradeItem = upgradeItem;
        this.result = result;
        this.group = group;
        this.type = type;
    }

    public boolean matches(@NotNull CraftingInput craftingContainer, @NotNull Level level) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (!this.type.test(x, y)) continue;
                required.add(craftingContainer.getItem(x + y * 3));
            }
        }
        return this.source.test(craftingContainer.getItem(4)) && required.stream().allMatch(this.upgradeItem);
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistryAccess) {
        ItemStack source = pContainer.getItem(4);
        ItemStack result = this.result.copy();
        result.applyComponents(source.getComponentsPatch());
        return result;
    }

    public Ingredient getUpgradeItem() {
        return this.upgradeItem;
    }

    public Ingredient getSource() {
        return this.source;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider pRegistryAccess) {
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public CraftType getCraftType() {
        return this.type;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i == 3 && j == 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ExtraRecipeSerializers.UPGRADE_ITEM.value();
    }

    public static enum CraftType implements StringRepresentable,
    BiPredicate<Integer, Integer>
    {
        EIGHT("eight", (x, y) -> x + 3 * y != 4),
        FOUR("four", (x, y) -> EIGHT.test(x, y) && x == 1 && y % 2 == 0 || y == 1 && x % 2 == 0),
        FOUR_DIAGONAL("four_diagonal", (x, y) -> EIGHT.test(x, y) && x % 2 == 0 && y % 2 == 0);

        static final StringRepresentable.EnumCodec<CraftType> CODEC;
        private final String name;
        private final PositionPredicate applyPredicate;

        private CraftType(String name, PositionPredicate applyPredicate) {
            this.name = name;
            this.applyPredicate = applyPredicate;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @Override
        public boolean test(Integer integer, Integer integer2) {
            return this.applyPredicate.apply(integer, integer2);
        }

        static {
            CODEC = StringRepresentable.fromEnum(CraftType::values);
        }
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeItemRecipe> {
        public static final MapCodec<UpgradeItemRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)CraftingBookCategory.CODEC.fieldOf("category").forGetter(CustomRecipe::category), (App)Ingredient.CODEC.fieldOf("source").forGetter(UpgradeItemRecipe::getSource), (App)Ingredient.CODEC.fieldOf("material").forGetter(UpgradeItemRecipe::getUpgradeItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(UpgradeItemRecipe::getResult), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(UpgradeItemRecipe::getGroup), (App)CraftType.CODEC.fieldOf("craft_type").forGetter(UpgradeItemRecipe::getCraftType)).apply((Applicative)i, UpgradeItemRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, UpgradeItemRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static UpgradeItemRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buf) {
            String s = buf.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            Ingredient source = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient upgradeItem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            CraftType type = (CraftType)buf.readEnum(CraftType.class);
            return new UpgradeItemRecipe(category, source, upgradeItem, stack, s, type);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, UpgradeItemRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum((Enum)recipe.category());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.source);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.upgradeItem);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            buf.writeEnum((Enum)recipe.type);
        }

        public MapCodec<UpgradeItemRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UpgradeItemRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    private static interface PositionPredicate {
        public boolean apply(int var1, int var2);
    }
}

