/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

public abstract class RequirementProvider<T>
implements DataProvider {
    private final Codec<Map<T, ReqCondition<?>>> codec;
    private final PackOutput output;
    private final String modId;
    private final RequirementType<T> type;
    private final Map<T, ReqCondition<?>> requirements = new HashMap();

    protected RequirementProvider(PackOutput output, String modId, RequirementType<T> type) {
        this.output = output;
        this.modId = modId;
        this.type = type;
        this.codec = Codec.unboundedMap(type.serializer().getCodec(), ReqCondition.CODEC);
    }

    protected void add(T element, ReqCondition<?> condition) {
        this.requirements.put(element, condition);
    }

    protected void add(Supplier<T> supplier, ReqCondition<?> condition) {
        this.add(supplier.get(), condition);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
        this.register();
        if (!this.requirements.isEmpty()) {
            return this.save(pOutput, this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("requirements").resolve(this.type.getName() + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        DataResult result = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.requirements);
        JsonElement element = (JsonElement)result.getOrThrow(IllegalArgumentException::new);
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)element, (Path)target);
    }

    protected abstract void register();

    @NotNull
    public String getName() {
        return this.modId + "-" + this.type.getName() + "-Requirements";
    }
}

