/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.abstracts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Function;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface EnchantmentBowEffect {
    public static final Codec<EnchantmentBowEffect> CODEC = ExtraRegistries.ENCHANTMENT_BOW_EFFECTS.byNameCodec().dispatch(EnchantmentBowEffect::codec, Function.identity());
    @ApiStatus.Internal
    public static final Multimap<ResourceLocation, ConditionalEffect<EnchantmentBowEffect>> executionMap = HashMultimap.create();
    public static final LootContextParamSet LOOT_PARAM_SET = LootContextParamSet.builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).optional(LootContextParams.ATTACKING_ENTITY).build();

    public static int getLevel(CompoundTag tag) {
        return tag.getInt("Level");
    }

    @ApiStatus.Internal
    public static float loadFromTag(LivingEntity target, CompoundTag tag, ExePhase type, float oldDamage, AbstractArrow arrow) {
        Level level = arrow.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder builder = new LootParams.Builder(serverLevel);
            builder.withParameter(LootContextParams.THIS_ENTITY, (Object)arrow).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)target);
            for (ResourceLocation location : executionMap.keySet()) {
                String string = location.toString();
                if (!tag.contains(string, 10)) continue;
                CompoundTag elementTag = tag.getCompound(string);
                int level2 = EnchantmentBowEffect.getLevel(elementTag);
                builder.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)level2);
                for (ConditionalEffect execution : executionMap.get((Object)location)) {
                    if (!execution.matches(new LootContext.Builder(builder.create(LOOT_PARAM_SET)).create(Optional.empty()))) continue;
                    oldDamage = ((EnchantmentBowEffect)execution.effect()).execute(level2, target, elementTag, type, oldDamage, arrow);
                }
            }
        }
        return oldDamage;
    }

    public CompoundTag write(CompoundTag var1, int var2, ItemStack var3, LivingEntity var4, AbstractArrow var5);

    public float execute(int var1, @Nullable LivingEntity var2, CompoundTag var3, ExePhase var4, float var5, AbstractArrow var6);

    public boolean shouldTick();

    public MapCodec<? extends EnchantmentBowEffect> codec();

    public static enum ExePhase {
        TICK,
        HIT;

    }
}

