/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.extras;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColorManager;
import net.kapitencraft.kap_lib.client.glyph.enchantment_applicable.EnchantmentApplicableAllocator;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.enchantments.abstracts.ModEnchantment;
import net.kapitencraft.kap_lib.event.custom.client.RegisterEnchantmentApplicableCharsEvent;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class EnchantmentDescriptionManager {
    private static final Style INFO_STYLE = Style.EMPTY.withColor(ChatFormatting.WHITE).withBold(Boolean.valueOf(false)).withStrikethrough(Boolean.valueOf(false)).withItalic(Boolean.valueOf(false)).withObfuscated(Boolean.valueOf(false)).withUnderlined(Boolean.valueOf(false));
    private static final ResourceLocation INFO_FONT_LOCATION = KapLibMod.res("enchantment_info");
    private static final ResourceLocation APPLICABLE_FONT_LOCATION = KapLibMod.res("enchantment_applicable");
    private static final char NO_TRADING = '\uf000';
    private static final char TREASURE = '\uf001';
    private static final List<Pair<Item, Character>> applicableMap = new ArrayList<Pair<Item, Character>>();
    private static final Map<Enchantment, String> applicableCache = new HashMap<Enchantment, String>();

    public static void addTooltip(Consumer<Component> tooltips, Holder<Enchantment> holder, int level) {
        String applicable;
        String display;
        Enchantment ench = (Enchantment)holder.value();
        MutableComponent component = Component.empty();
        component.append(ench.description());
        if (level != 1 || ench.getMaxLevel() > 1) {
            component.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + level)));
        }
        component.withStyle(MiscHelper.nonNullOr(EnchantmentColorManager.getStyle(holder, level), Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (ClientModConfig.showObtainDisplay() && !(display = EnchantmentDescriptionManager.addObtainDisplay(holder)).isEmpty()) {
            component.append(CommonComponents.SPACE);
            component.append((Component)Component.literal((String)display).withStyle(INFO_STYLE.withFont(INFO_FONT_LOCATION)));
        }
        if (ClientModConfig.showApplyDisplay() && !(applicable = EnchantmentDescriptionManager.getApplicable(ench)).isEmpty()) {
            component.append(CommonComponents.SPACE);
            component.append((Component)Component.literal((String)applicable).withStyle(INFO_STYLE.withFont(APPLICABLE_FONT_LOCATION)));
        }
        tooltips.accept((Component)component);
        if (Screen.hasShiftDown()) {
            EnchantmentDescriptionManager.addTooltipForEnchant(tooltips, holder, level);
        }
    }

    public static boolean fromBook(Item item) {
        return item instanceof EnchantedBookItem;
    }

    public static String addObtainDisplay(Holder<Enchantment> enchantment) {
        Object s = "";
        if (enchantment.is(EnchantmentTags.TREASURE)) {
            s = (String)s + "\uf001";
        }
        if (!enchantment.is(EnchantmentTags.TRADEABLE)) {
            s = (String)s + "\uf000";
        }
        return s;
    }

    public static void addTooltipForEnchant(Consumer<Component> list, Holder<Enchantment> enchantment, int level) {
        EnchantmentDescriptionManager.getDescription(enchantment, level).forEach(list);
    }

    public static List<Component> getDescription(Holder<Enchantment> ench, int level) {
        Object[] objectArray;
        if (ench instanceof ModEnchantment) {
            ModEnchantment modEnchantment = (ModEnchantment)ench;
            objectArray = modEnchantment.getDescriptionMods(level);
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = level;
        }
        Object[] objects = objectArray;
        Stream<String> stream = Arrays.stream(objects).map(String::valueOf);
        return TextHelper.getDescriptionOrEmpty(Util.makeDescriptionId((String)"enchantment", (ResourceLocation)ench.getKey().location()), component -> component.withStyle(ChatFormatting.DARK_GRAY), stream.map(TextHelper::wrapInRed).toArray());
    }

    private static void addItem(Item item, ResourceLocation location) {
        applicableMap.add((Pair<Item, Character>)Pair.of((Object)item, (Object)Character.valueOf(EnchantmentApplicableAllocator.getInstance().addEntry(location))));
    }

    private static void addItem(Item item) {
        EnchantmentDescriptionManager.addItem(item, BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/"));
    }

    public static void initApplication() {
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_BOOTS);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_LEGGINGS);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_CHESTPLATE);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_HELMET);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_PICKAXE);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_SWORD);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_AXE);
        EnchantmentDescriptionManager.addItem(Items.DIAMOND_HOE);
        EnchantmentDescriptionManager.addItem(Items.BOW);
        EnchantmentDescriptionManager.addItem(Items.CROSSBOW, ResourceLocation.withDefaultNamespace((String)"item/crossbow_standby"));
        EnchantmentDescriptionManager.addItem(Items.ELYTRA);
        EnchantmentDescriptionManager.addItem(Items.SHEARS);
        EnchantmentDescriptionManager.addItem(Items.MACE);
        EnchantmentDescriptionManager.addItem(Items.TRIDENT);
        EnchantmentDescriptionManager.addItem(Items.FISHING_ROD);
        NeoForge.EVENT_BUS.post((Event)new RegisterEnchantmentApplicableCharsEvent(EnchantmentDescriptionManager::addItem, EnchantmentDescriptionManager::addItem));
    }

    private static String getApplicable(Enchantment enchantment) {
        if (applicableMap.isEmpty()) {
            EnchantmentDescriptionManager.initApplication();
        }
        if (applicableCache.containsKey(enchantment)) {
            return applicableCache.get(enchantment);
        }
        StringBuilder s = new StringBuilder();
        Enchantment.EnchantmentDefinition definition = enchantment.definition();
        for (Pair<Item, Character> test : applicableMap) {
            if (!definition.supportedItems().contains((Holder)((Item)test.getFirst()).builtInRegistryHolder())) continue;
            s.append(test.getSecond());
        }
        String value = s.toString();
        applicableCache.put(enchantment, value);
        return value;
    }
}

