/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.entity.fishing;

import net.kapitencraft.kap_lib.entity.fishing.IFishingHook;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFishingHook
extends FishingHook
implements IFishingHook {
    private TagKey<Fluid> fluidType;
    private int hookSpeedModifier;

    private AbstractFishingHook(EntityType<? extends AbstractFishingHook> type, Level level, int luck, int lureSpeed, TagKey<Fluid> fluidType) {
        super(type, level, luck, lureSpeed);
        this.fluidType = fluidType;
    }

    protected AbstractFishingHook(EntityType<? extends AbstractFishingHook> type, Level level, TagKey<Fluid> fluidType) {
        this(type, level, 0, 0, fluidType);
    }

    protected AbstractFishingHook(EntityType<? extends AbstractFishingHook> type, Player player, Level level, int luck, int lureSpeed, TagKey<Fluid> fluidType) {
        this(type, level, luck, lureSpeed, fluidType);
        this.setOwner((Entity)player);
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putString("fluidType", this.fluidType.location().toString());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.fluidType = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)tag.getString("fluidType")));
    }

    @Override
    public TagKey<Fluid> getFluidType() {
        return this.fluidType;
    }

    @Override
    public int getHookSpeedModifier() {
        return this.hookSpeedModifier;
    }

    @Override
    public void setHookSpeedModifier(int hookSpeedModifier) {
        this.hookSpeedModifier = hookSpeedModifier;
    }
}

