/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolSingletonContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class NestedSpawnTable
extends SpawnPoolSingletonContainer {
    public static final MapCodec<NestedSpawnTable> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SpawnTable.GATHER_CODEC.fieldOf("value").forGetter(f -> f.entry)).and(NestedSpawnTable.singletonFields(i)).apply((Applicative)i, NestedSpawnTable::new));
    final Either<ResourceKey<SpawnTable>, SpawnTable> entry;

    NestedSpawnTable(Either<ResourceKey<SpawnTable>, SpawnTable> pLootTableId, int pWeight, int pQuality, List<LootItemCondition> pConditions, List<SpawnEntityFunction> pFunctions) {
        super(pWeight, pQuality, pConditions, pFunctions);
        this.entry = pLootTableId;
    }

    @Override
    public SpawnPoolEntryType getType() {
        return SpawnPoolEntries.REFERENCE.get();
    }

    @Override
    public void createEntity(Consumer<Entity> stackConsumer, SpawnContext lootContext) {
        ((SpawnTable)this.entry.map(p_335324_ -> lootContext.getResolver().get(ExtraRegistries.Keys.SPAWN_TABLES, p_335324_).map(Holder::value).orElse(SpawnTable.EMPTY), Function.identity())).getRandomEntitiesRaw(lootContext, stackConsumer);
    }

    @Override
    public void validate(ValidationContext validationContext) {
        Optional optional = this.entry.left();
        if (optional.isPresent()) {
            ResourceKey resourcekey = (ResourceKey)optional.get();
            if (!validationContext.allowsReferences()) {
                validationContext.reportProblem("Uses reference to " + String.valueOf(resourcekey.location()) + ", but references are not allowed");
                return;
            }
            if (validationContext.hasVisitedElement(resourcekey)) {
                validationContext.reportProblem("Table " + String.valueOf(resourcekey.location()) + " is recursively called");
                return;
            }
        }
        super.validate(validationContext);
        this.entry.ifLeft(p_335332_ -> validationContext.resolver().get(ExtraRegistries.Keys.SPAWN_TABLES, p_335332_).ifPresentOrElse(p_339565_ -> ((SpawnTable)p_339565_.value()).validate(validationContext.enterElement("->{" + String.valueOf(p_335332_.location()) + "}", p_335332_)), () -> validationContext.reportProblem("Unknown loot table called " + String.valueOf(p_335332_.location())))).ifRight(p_331183_ -> p_331183_.validate(validationContext.forChild("->{inline}")));
    }

    public static SpawnPoolSingletonContainer.Builder<?> spawnTableReference(ResourceKey<SpawnTable> pTable) {
        return NestedSpawnTable.simpleBuilder((p_79780_, p_79781_, p_79782_, p_79783_) -> new NestedSpawnTable((Either<ResourceKey<SpawnTable>, SpawnTable>)Either.left((Object)pTable), p_79780_, p_79781_, p_79782_, p_79783_));
    }

    public static SpawnPoolSingletonContainer.Builder<?> inlineSpawnTable(SpawnTable table) {
        return NestedSpawnTable.simpleBuilder((pWeight, pQuality, pConditions, pFunctions) -> new NestedSpawnTable((Either<ResourceKey<SpawnTable>, SpawnTable>)Either.right((Object)table), pWeight, pQuality, pConditions, pFunctions));
    }
}

