/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions.core;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class SpawnEntityConditionalFunction
implements SpawnEntityFunction {
    protected final List<LootItemCondition> predicates;
    private final Predicate<LootContext> compositePredicates;

    protected SpawnEntityConditionalFunction(List<LootItemCondition> pPredicates) {
        this.predicates = pPredicates;
        this.compositePredicates = Util.allOf(pPredicates);
    }

    protected static void logWrongType(String name, Entity entity) {
        KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "{} was no {}", (Object)entity, (Object)name);
    }

    protected static <T extends SpawnEntityConditionalFunction> Products.P1<RecordCodecBuilder.Mu<T>, List<LootItemCondition>> commonFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(p_299114_ -> p_299114_.predicates));
    }

    @Override
    public final Entity apply(Entity pEntity, SpawnContext pContext) {
        return this.compositePredicates.test(pContext) ? this.run(pEntity, pContext) : pEntity;
    }

    protected abstract Entity run(Entity var1, SpawnContext var2);

    public void validate(ValidationContext pContext) {
        SpawnEntityFunction.super.validate(pContext);
        for (int i = 0; i < this.predicates.size(); ++i) {
            this.predicates.get(i).validate(pContext.forChild(".conditions[" + i + "]"));
        }
    }

    protected static Builder<?> simpleBuilder(Function<List<LootItemCondition>, SpawnEntityFunction> pConstructor) {
        return new DummyBuilder(pConstructor);
    }

    static final class DummyBuilder
    extends Builder<DummyBuilder> {
        private final Function<List<LootItemCondition>, SpawnEntityFunction> constructor;

        public DummyBuilder(Function<List<LootItemCondition>, SpawnEntityFunction> pConstructor) {
            this.constructor = pConstructor;
        }

        @Override
        protected DummyBuilder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return this.constructor.apply(this.getConditions());
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    implements SpawnEntityFunction.Builder,
    ConditionUserBuilder<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        public T when(LootItemCondition.Builder p_80694_) {
            this.conditions.add(p_80694_.build());
            return this.getThis();
        }

        public final T unwrap() {
            return this.getThis();
        }

        protected abstract T getThis();

        protected List<LootItemCondition> getConditions() {
            return this.conditions;
        }
    }
}

