/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.Command;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.armor.ArmorClientExtension;
import net.kapitencraft.kap_lib.client.armor.provider.ArmorModelProvider;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.item.combat.armor.AbstractArmorItem;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelper {
    @ApiStatus.Internal
    public static Screen postCommandScreen = null;
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_BEAM_LOCATION);

    public static Command<CommandSourceStack> createScreenCommand(Supplier<Screen> creator) {
        return stack -> {
            postCommandScreen = (Screen)creator.get();
            return 1;
        };
    }

    public static void renderBeam(Vec3 start, LivingEntity living, int r, int g, int b, PoseStack stack, MultiBufferSource source, RenderType renderType) {
        float f1 = living.level().getGameTime();
        float f2 = f1 * 0.5f % 1.0f;
        stack.pushPose();
        stack.translate(start.x, start.y, start.z);
        Vec3 stop = living.position().add(0.0, (double)living.getBbHeight() * 0.5, 0.0);
        Vec3 vec32 = stop.subtract(start);
        float f4 = (float)(vec32.length() + 1.0);
        vec32 = vec32.normalize();
        float f5 = (float)Math.acos(vec32.y);
        float f6 = (float)Math.atan2(vec32.z, vec32.x);
        stack.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
        stack.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
        float f7 = f1 * 0.05f * -1.5f;
        float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
        float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
        float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
        float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
        float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
        float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
        float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
        float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
        float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
        float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
        float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
        float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
        float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = -1.0f + f2;
        float f30 = f4 * 2.5f + f29;
        VertexConsumer vertexconsumer = source.getBuffer(renderType);
        PoseStack.Pose pose = stack.last();
        Matrix4f matrix4f = pose.pose();
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f19, f4, f20, r, g, b, 0.4999f, f30);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f19, 0.0f, f20, r, g, b, 0.4999f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f21, 0.0f, f22, r, g, b, 0.0f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f21, f4, f22, r, g, b, 0.0f, f30);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f23, f4, f24, r, g, b, 0.4999f, f30);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f23, 0.0f, f24, r, g, b, 0.4999f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f25, 0.0f, f26, r, g, b, 0.0f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f25, f4, f26, r, g, b, 0.0f, f30);
        float f31 = 0.0f;
        if (living.tickCount % 2 == 0) {
            f31 = 0.5f;
        }
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f11, f4, f12, r, g, b, 0.5f, f31 + 0.5f);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f13, f4, f14, r, g, b, 1.0f, f31 + 0.5f);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f17, f4, f18, r, g, b, 1.0f, f31);
        ClientHelper.vertex(vertexconsumer, matrix4f, pose, f15, f4, f16, r, g, b, 0.5f, f31);
        stack.popPose();
    }

    private static <T extends AbstractArmorItem> void registerArmorExtension(Map<ArmorItem.Type, DeferredItem<T>> map, RegisterClientExtensionsEvent event, ArmorModelProvider provider) {
        event.registerItem((IClientItemExtensions)new ArmorClientExtension(provider), (Holder[])map.values().toArray(DeferredItem[]::new));
    }

    private static void vertex(VertexConsumer p_253637_, Matrix4f p_253920_, PoseStack.Pose p_253881_, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        p_253637_.addVertex(p_253920_, p_253994_, p_254492_, p_254474_).setColor(p_254080_, p_253655_, p_254133_, 255).setUv(p_254233_, p_253939_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(p_253881_, 0.0f, 1.0f, 0.0f);
    }

    public static void drawCenteredString(GuiGraphics graphics, int xStart, int yStart, int xEnd, int yEnd, Component toDraw, int color) {
        Font font = Minecraft.getInstance().font;
        int height = yEnd - yStart;
        int width = xEnd - xStart;
        int xDrawStart = xStart + width / 2;
        int yDrawStart = yStart + height / 2 - 4;
        graphics.drawCenteredString(font, toDraw, xDrawStart, yDrawStart, color);
    }

    public static void changeCursorType(int arrowId) {
        Minecraft minecraft = Minecraft.getInstance();
        long windowId = minecraft.getWindow().getWindow();
        minecraft.execute(() -> GLFW.glfwSetCursor((long)windowId, (long)GLFW.glfwCreateStandardCursor((int)arrowId)));
    }

    public static <T> void addReqContent(Consumer<Component> consumer, RequirementType<T> type, T t, @Nullable LivingEntity living) {
        if (RequirementManager.instance == null) {
            return;
        }
        List reqs = CollectionHelper.mutableList(RequirementManager.instance.getReqs(type, t));
        if (living != null) {
            reqs.removeIf(itemRequirement -> itemRequirement.matches(living));
        }
        if (!reqs.isEmpty()) {
            MutableComponent reqList = Component.empty();
            reqs.stream().map(ReqCondition::display).filter(MutableComponent.class::isInstance).map(MutableComponent.class::cast).map(component -> component.withStyle(ChatFormatting.RED)).forEach(consumer);
        }
    }

    public static boolean hideGui() {
        return Minecraft.getInstance().options.hideGui;
    }

    public static void sendElytraBoostParticles(Entity target, RandomSource random, Vec3 delta, Color startColor, Color fadeColor) {
        Level level = target.level();
        if (!level.isClientSide()) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        Vec3 loc = MathHelper.getHandHoldingItemAngle(HumanoidArm.LEFT, target);
        ClientHelper.addParticle(clientLevel, loc, random, delta, startColor, fadeColor);
        loc = MathHelper.getHandHoldingItemAngle(HumanoidArm.RIGHT, target);
        ClientHelper.addParticle(clientLevel, loc, random, delta, startColor, fadeColor);
    }

    @ApiStatus.Internal
    private static void addParticle(ClientLevel level, Vec3 loc, RandomSource random, Vec3 delta, Color startColor, Color fadeColor) {
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        SpriteSet spriteSet = (SpriteSet)engine.spriteSets.get(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.FIREWORK.getType()));
        FireworkParticles.SparkParticle particle = new FireworkParticles.SparkParticle(level, loc.x, loc.y, loc.z, random.nextGaussian() * 0.05, -delta.y * 0.5, random.nextGaussian() * 0.05, engine, spriteSet);
        particle.setColor(startColor.r(), startColor.g(), startColor.b());
        particle.setFadeColor(fadeColor.pack());
        engine.add((Particle)particle);
    }

    public static void fill(GuiGraphics graphics, float xStart, float yStart, float xEnd, float yEnd, int color, int blitOffset) {
        ClientHelper.innerFill(graphics.pose().last().pose(), xStart, yStart, xEnd, yEnd, color, blitOffset);
    }

    @ApiStatus.Internal
    private static void innerFill(Matrix4f p_254518_, float xStart, float yStart, float xEnd, float yEnd, int color, int blitOffset) {
        float i;
        if (xStart < xEnd) {
            i = xStart;
            xStart = xEnd;
            xEnd = i;
        }
        if (yStart < yEnd) {
            i = yStart;
            yStart = yEnd;
            yEnd = i;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(p_254518_, xStart, yEnd, (float)blitOffset).setColor(f, f1, f2, f3);
        builder.addVertex(p_254518_, xEnd, yEnd, (float)blitOffset).setColor(f, f1, f2, f3);
        builder.addVertex(p_254518_, xEnd, yStart, (float)blitOffset).setColor(f, f1, f2, f3);
        builder.addVertex(p_254518_, xStart, yStart, (float)blitOffset).setColor(f, f1, f2, f3);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static float getScreenWidth() {
        return Objects.requireNonNull(Minecraft.getInstance().screen, (String)"active screen is null!").width;
    }

    public static float getScreenHeight() {
        return Objects.requireNonNull(Minecraft.getInstance().screen, (String)"active screen is null!").height;
    }

    @NotNull
    public static Entity getEntity(int id) {
        return Objects.requireNonNull(Objects.requireNonNull(Minecraft.getInstance().level, "Client Level is null!").getEntity(id), "missing entity with id " + id);
    }

    @Nullable
    public static Entity getNullableEntity(int id) {
        return Objects.requireNonNull(Minecraft.getInstance().level, "Client Level is null!").getEntity(id);
    }
}

