/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.BiFunction;
import net.kapitencraft.kap_lib.client.enchantment_color.ConfigureEnchantmentColorsCommand;
import net.kapitencraft.kap_lib.client.overlay.OverlaysCommand;
import net.kapitencraft.kap_lib.commands.ClientTestCommand;
import net.kapitencraft.kap_lib.commands.ServerTestCommand;
import net.kapitencraft.kap_lib.config.ServerModConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface CommandHelper {
    @ApiStatus.Internal
    public static void registerClient(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        OverlaysCommand.register((CommandDispatcher)dispatcher);
        ClientTestCommand.register((CommandDispatcher)dispatcher);
        ConfigureEnchantmentColorsCommand.register((CommandDispatcher)dispatcher);
    }

    @ApiStatus.Internal
    public static void registerServer(RegisterCommandsEvent event) {
        ServerTestCommand.register((CommandDispatcher)event.getDispatcher());
    }

    public static void sendSuccess(CommandSourceStack stack, String msg, Object ... args) {
        stack.sendSuccess(() -> Component.translatable((String)msg, (Object[])args).withStyle(ChatFormatting.GREEN), true);
    }

    public static int checkNonConsoleCommand(CommandContext<CommandSourceStack> context, BiFunction<@NotNull ServerPlayer, CommandSourceStack, Integer> function) {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        if (stack.getPlayer() != null) {
            return function.apply(stack.getPlayer(), stack);
        }
        stack.sendFailure((Component)Component.translatable((String)"command.failed.console").withStyle(ChatFormatting.RED));
        return 0;
    }

    public static boolean isModerator(CommandSourceStack stack) {
        return stack.hasPermission(1);
    }

    public static boolean isGameMaster(CommandSourceStack stack) {
        return stack.hasPermission(2);
    }

    public static boolean isAdmin(CommandSourceStack stack) {
        return stack.hasPermission(3);
    }

    public static boolean isOwner(CommandSourceStack stack) {
        return stack.hasPermission(4);
    }

    public static boolean isSocialEnabled(CommandSourceStack stack) {
        return ServerModConfig.areSocialCommandsEnabled();
    }
}

