/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.glyph.player_head;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.GlyphRenderTypes;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.gametest.GameTestHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PlayerHeadAllocator
extends FontSet {
    private static final ResourceLocation UNKNOWN = KapLibMod.res("textures/font/unknown_player.png");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static PlayerHeadAllocator instance;
    public static final ResourceLocation FONT;
    private static final GlyphInfo GLYPH_INFO;
    private final SkinManager skinManager;
    private final TextureManager textureManager;
    private NativeImage unknown;
    private NativeImage atlas;
    private DynamicTexture atlasTexture;
    private final Map<UUID, Character> lookup;
    private final Map<UUID, FormattedText> textLookup;
    private int index = 0;
    private int maxIndex = 24;
    private final GlyphRenderTypes renderTypes = GlyphRenderTypes.createForColorTexture((ResourceLocation)FONT);
    private BakedGlyph[] glyphs;
    private final List<PendingEntry> pending = new ArrayList<PendingEntry>();

    private void checkPending(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.pending.stream().filter(e -> e.uuid == player.getUUID()).forEach(pendingEntry -> this.register(player.getGameProfile(), pendingEntry.id));
        }
    }

    public PlayerHeadAllocator(SkinManager skinManager, TextureManager manager) {
        super(manager, FONT);
        this.skinManager = skinManager;
        this.textureManager = manager;
        this.lookup = new HashMap<UUID, Character>();
        this.textLookup = new HashMap<UUID, FormattedText>();
        this.load();
        NeoForge.EVENT_BUS.addListener(this::checkPending);
        instance = this;
    }

    public static PlayerHeadAllocator getInstance() {
        return instance;
    }

    public FormattedText getTextForPlayer(UUID player) {
        return this.textLookup.computeIfAbsent(player, this::addPlayerText);
    }

    private FormattedText addPlayerText(UUID uuid) {
        return FormattedText.of((String)String.valueOf(PlayerHeadAllocator.getInstance().getGlyphForPlayer(uuid)), (Style)Style.EMPTY.withFont(FONT));
    }

    public char getGlyphForPlayer(UUID player) {
        return this.lookup.computeIfAbsent(player, this::addPlayer).charValue();
    }

    @NotNull
    public GlyphInfo getGlyphInfo(int pCharacter, boolean pFilterFishyGlyphs) {
        return GLYPH_INFO;
    }

    private char addPlayer(UUID uuid) {
        if (this.index >= this.maxIndex) {
            this.reallocate();
        }
        int index = this.index++;
        Minecraft.getInstance().tell(() -> this.addDummySkin(index));
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && level.getPlayerByUUID(uuid) != null) {
            GameProfile profile = level.getPlayerByUUID(uuid).getGameProfile();
            this.register(profile, index);
        } else {
            this.pending.add(new PendingEntry(uuid, index));
        }
        return (char)index;
    }

    public void register(GameProfile profile, int id) {
        this.skinManager.getOrLoad(profile).thenAccept(s -> Minecraft.getInstance().tell(() -> this.addSkin(s.texture(), id)));
    }

    private void addDummySkin(int index) {
        this.addGlyph(index);
        this.addPlayerHeadToAtlas(index, this.gatherDummy());
    }

    private NativeImage gatherDummy() {
        if (this.unknown != null) {
            return this.unknown;
        }
        NativeImage nativeimage = new NativeImage(72, 72, false);
        this.textureManager.getTexture(UNKNOWN).bind();
        nativeimage.downloadTexture(0, false);
        this.unknown = nativeimage;
        return nativeimage;
    }

    private void reallocate() {
        KapLibMod.LOGGER.debug("re-allocating player head atlas");
        NativeImage original = this.atlas;
        NativeImage image = new NativeImage(original.getWidth() * 2, original.getHeight(), false);
        original.copyRect(image, 0, 0, 0, 0, original.getWidth(), original.getHeight(), false, false);
        original.close();
        this.atlas = image;
        this.atlasTexture = new DynamicTexture(this.atlas);
        this.textureManager.register(FONT, (AbstractTexture)this.atlasTexture);
        BakedGlyph[] oldGlyphs = this.glyphs;
        BakedGlyph[] newGlyphs = new BakedGlyph[oldGlyphs.length * 2];
        System.arraycopy(oldGlyphs, 0, newGlyphs, 0, oldGlyphs.length);
        this.glyphs = newGlyphs;
        this.maxIndex = newGlyphs.length - 1;
    }

    private synchronized void addSkin(ResourceLocation resourceLocation, int index) {
        Minecraft.getInstance().execute(() -> {
            TextureTarget renderTarget = new TextureTarget(72, 72, true, false);
            Matrix4f matrix = new Matrix4f();
            matrix.setOrtho(0.0f, 72.0f, 72.0f, 0.0f, -1.0f, 1.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            RenderSystem.applyModelViewMatrix();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            renderTarget.bindWrite(true);
            RenderSystem.clearColor((float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            RenderSystem.clear((int)16640, (boolean)true);
            float headStart = 0.125f;
            float headEnd = 0.25f;
            bufferBuilder.addVertex(4.0f, 4.0f, 0.0f).setUv(headStart, headStart);
            bufferBuilder.addVertex(4.0f, 68.0f, 0.0f).setUv(headStart, headEnd);
            bufferBuilder.addVertex(68.0f, 68.0f, 0.0f).setUv(headEnd, headEnd);
            bufferBuilder.addVertex(68.0f, 4.0f, 0.0f).setUv(headEnd, headStart);
            float hatUStart = 0.625f;
            float hatVStart = 0.125f;
            float hatUEnd = 0.75f;
            float hatVEnd = 0.25f;
            bufferBuilder.addVertex(0.0f, 0.0f, 0.0f).setUv(hatUStart, hatVStart);
            bufferBuilder.addVertex(0.0f, 72.0f, 0.0f).setUv(hatUStart, hatVEnd);
            bufferBuilder.addVertex(72.0f, 72.0f, 0.0f).setUv(hatUEnd, hatVEnd);
            bufferBuilder.addVertex(72.0f, 0.0f, 0.0f).setUv(hatUEnd, hatVStart);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            renderTarget.unbindWrite();
            RenderSystem.disableBlend();
            NativeImage image = PlayerHeadAllocator.makeTransparentScreenshot((RenderTarget)renderTarget);
            this.addPlayerHeadToAtlas(index, image);
            this.atlasTexture.upload();
        });
    }

    private void addPlayerHeadToAtlas(int index, NativeImage image) {
        int x = index % 10 * 72;
        int y = index / 10 * 72;
        image.copyRect(this.atlas, 0, 0, x, y, 72, 72, false, false);
        if (GameTestHooks.isGametestEnabled()) {
            try {
                File file = new File("debug_result.png");
                if (!file.exists()) {
                    file.createNewFile();
                }
                image.writeToFile(file);
                File atlas = new File("atlas.png");
                if (!atlas.exists()) {
                    atlas.createNewFile();
                }
                this.atlas.writeToFile(atlas);
            }
            catch (Exception e) {
                KapLibMod.LOGGER.warn("error saving result: {}", (Object)e.getMessage());
            }
        }
        image.close();
    }

    private static NativeImage makeTransparentScreenshot(RenderTarget pFrameBuffer) {
        int i = pFrameBuffer.width;
        int j = pFrameBuffer.height;
        NativeImage nativeimage = new NativeImage(i, j, false);
        RenderSystem.bindTexture((int)pFrameBuffer.getColorTextureId());
        nativeimage.downloadTexture(0, false);
        nativeimage.flipY();
        return nativeimage;
    }

    @NotNull
    public BakedGlyph getGlyph(int pCharacter) {
        if (this.glyphs[pCharacter] == null) {
            this.addGlyph(pCharacter);
        }
        return this.glyphs[pCharacter];
    }

    @NotNull
    public BakedGlyph getRandomGlyph(GlyphInfo pGlyph) {
        return this.glyphs[Mth.nextInt((RandomSource)KapLibMod.RANDOM_SOURCE, (int)0, (int)this.index)];
    }

    private void addGlyph(int index) {
        int x = index % 10 * 72;
        int y = index / 10 * 72;
        float atlasWidth = this.atlas.getWidth();
        float atlasHeight = this.atlas.getHeight();
        this.glyphs[index] = new BakedGlyph(this.renderTypes, (float)x / atlasWidth, (float)(x + 72) / atlasWidth, (float)y / atlasHeight, (float)(y + 72) / atlasHeight, 0.0f, 8.0f, -1.0f, 7.5f);
    }

    public void init() {
        this.glyphs = new BakedGlyph[25];
        this.atlas = new NativeImage(360, 360, false);
        this.atlasTexture = new DynamicTexture(this.atlas);
        this.textureManager.register(FONT, (AbstractTexture)this.atlasTexture);
        this.atlasTexture.upload();
        this.lookup.clear();
        this.textLookup.clear();
        this.index = 0;
        this.maxIndex = 24;
    }

    public void shutDown() {
        if (ClientModConfig.cachePlayerHeads() && this.index > 0) {
            File root = new File(KapLibMod.ROOT, "player_heads");
            File image = new File(root, "image.png");
            root.mkdirs();
            try {
                if (!image.exists() && !image.createNewFile()) {
                    LOGGER.warn("unable to create file");
                    return;
                }
                this.atlas.writeToFile(image);
                File data = new File(root, "data.json");
                IOHelper.saveFile(data, CacheData.CODEC, this.createCacheData());
            }
            catch (IOException e) {
                LOGGER.warn("unable to save player head data: {}", (Object)e.getMessage());
            }
        }
    }

    private CacheData createCacheData() {
        UUID[] data = new UUID[this.index];
        for (Map.Entry<UUID, Character> entry : this.lookup.entrySet()) {
            data[entry.getValue().charValue()] = entry.getKey();
        }
        return new CacheData(this.maxIndex + 1, List.of(data));
    }

    public void reset() {
        this.atlasTexture.close();
        this.init();
    }

    public void load() {
        File root = new File(KapLibMod.ROOT, "player_heads");
        if (!root.exists()) {
            this.init();
            return;
        }
        File imageFile = new File(root, "image.png");
        try {
            NativeImage image = NativeImage.read((byte[])Files.readAllBytes(imageFile.toPath()));
            if (image.getWidth() % 360 != 0 || image.getHeight() % 360 != 0) {
                LOGGER.warn("unexpected image dimensions: [{}, {}]", (Object)image.getWidth(), (Object)image.getHeight());
                return;
            }
            this.atlas = image;
            this.atlasTexture = new DynamicTexture(this.atlas);
            this.textureManager.register(FONT, (AbstractTexture)this.atlasTexture);
            this.atlasTexture.upload();
            File data = new File(root, "data.json");
            DataResult result = CacheData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)new JsonReader((Reader)new FileReader(data))));
            result.resultOrPartial(w -> LOGGER.warn("error loading player heads: {}", w)).ifPresent(this::copyFrom);
        }
        catch (IOException e) {
            LOGGER.warn("unable to load player heads: {}", (Object)e.getMessage());
        }
    }

    private void copyFrom(CacheData cacheData) {
        int i;
        this.maxIndex = cacheData.size - 1;
        this.lookup.clear();
        for (i = 0; i < cacheData.players.size(); ++i) {
            UUID uuid = cacheData.players.get(i);
            this.lookup.put(uuid, Character.valueOf((char)i));
        }
        this.glyphs = new BakedGlyph[cacheData.size];
        for (i = 0; i < this.maxIndex; ++i) {
            this.addGlyph(i);
        }
    }

    static {
        FONT = KapLibMod.res("player_heads");
        GLYPH_INFO = new GlyphInfo(){

            public float getAdvance() {
                return 10.0f;
            }

            public BakedGlyph bake(Function<SheetGlyphInfo, BakedGlyph> pGlyphProvider) {
                return null;
            }
        };
    }

    private record PendingEntry(UUID uuid, int id) {
    }

    private record CacheData(int size, List<UUID> players) {
        private static final Codec<CacheData> CODEC = RecordCodecBuilder.create(cacheDataInstance -> cacheDataInstance.group((App)Codec.INT.fieldOf("size").forGetter(CacheData::size), (App)UUIDUtil.STRING_CODEC.listOf().fieldOf("players").forGetter(CacheData::players)).apply((Applicative)cacheDataInstance, CacheData::new));
    }
}

