/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.activation_triggers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.ActivationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.TriggerInstance;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ActivationTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;

public class EntityAddedTrigger
implements ActivationTrigger<Instance> {
    private static final StreamCodec<? super RegistryFriendlyByteBuf, Instance> STREAM_CODEC = ByteBufCodecs.INT.map(Instance::new, i -> i.entityId);
    private final Multimap<Integer, ActivationTrigger.Listener<Instance>> instances = HashMultimap.create();

    public static TriggerInstance forEntity(Entity entity) {
        return new Instance(entity.getId());
    }

    @Override
    public void addListener(ActivationTrigger.Listener<Instance> instance) {
        this.instances.put((Object)instance.getTrigger().entityId, instance);
    }

    @Override
    public void removeListener(ActivationTrigger.Listener<Instance> instance) {
        this.instances.remove((Object)instance.getTrigger().entityId, instance);
    }

    @Override
    public boolean active(ActivationTrigger.Listener<Instance> instance) {
        return Objects.requireNonNull(Minecraft.getInstance().level).getEntity(instance.getTrigger().entityId) != null;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, Instance> codec() {
        return STREAM_CODEC;
    }

    public void trigger(int id) {
        this.instances.get((Object)id).forEach(ActivationTrigger.Listener::run);
        this.instances.removeAll((Object)id);
    }

    public static class Instance
    implements TriggerInstance {
        private final int entityId;

        public Instance(int entityId) {
            this.entityId = entityId;
        }

        public EntityAddedTrigger getTrigger() {
            return ActivationTriggers.ENTITY_ADDED.get();
        }

        public String toString() {
            return "EntityAddedTrigger[" + this.entityId + "]";
        }
    }
}

