/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.util.rot_target;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.client.util.rot_target.AbsoluteRotationTarget;
import net.kapitencraft.kap_lib.client.util.rot_target.FromEntityRotationTarget;
import net.kapitencraft.kap_lib.client.util.rot_target.TrackPositionRotationTarget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;

public interface RotationTarget
extends Supplier<Vec2> {
    public static final StreamCodec<RegistryFriendlyByteBuf, RotationTarget> CODEC = StreamCodec.of(Types::toNw, RotationTarget::fromNw);

    public static RotationTarget fromNw(RegistryFriendlyByteBuf buf) {
        Types t = Types.values()[buf.readInt()];
        return (RotationTarget)t.type.codec().decode((Object)buf);
    }

    public static RotationTarget absolute(float x, float y) {
        return new AbsoluteRotationTarget(new Vec2(x, y));
    }

    public static RotationTarget absolute(Vec2 rot) {
        return new AbsoluteRotationTarget(rot);
    }

    public static RotationTarget forEntity(Entity entity) {
        return new FromEntityRotationTarget(entity.getId());
    }

    @Override
    public Vec2 get();

    public Types getType();

    public static enum Types implements IExtensibleEnum
    {
        TRACK_POSITION(TrackPositionRotationTarget.Type::new),
        ABSOLUTE(AbsoluteRotationTarget.Type::new),
        FROM_ENTITY(FromEntityRotationTarget.Type::new);

        private final Type<? extends RotationTarget> type;

        private Types(Supplier<Type<? extends RotationTarget>> typeSupplier) {
            this.type = typeSupplier.get();
        }

        private static <T extends RotationTarget> void toNw(RegistryFriendlyByteBuf buf, T val) {
            Types types = val.getType();
            buf.writeInt(types.ordinal());
            types.type.codec().encode((Object)buf, val);
        }

        public static Types create(String name, Supplier<PositionTarget.Type<? extends PositionTarget>> typeSupplier) {
            throw new IllegalAccessError("enum not extended!");
        }
    }

    public static interface Type<T extends RotationTarget> {
        public StreamCodec<? super RegistryFriendlyByteBuf, T> codec();
    }
}

