/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst.recipe;

import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.crafting.serializers.UpgradeItemRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;

public class UpgradeRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final UpgradeItemRecipe.CraftType type;
    private final Item result;
    private final int count;
    private Ingredient source;
    private Ingredient material;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();
    @Nullable
    private String group;

    public UpgradeRecipeBuilder(RecipeCategory pCategory, UpgradeItemRecipe.CraftType type, ItemLike pResult, int pCount) {
        this.category = pCategory;
        this.type = type;
        this.result = pResult.asItem();
        this.count = pCount;
    }

    public static UpgradeRecipeBuilder create(RecipeCategory pCategory, UpgradeItemRecipe.CraftType type, ItemLike pResult) {
        return UpgradeRecipeBuilder.create(pCategory, type, pResult, 1);
    }

    public static UpgradeRecipeBuilder create(RecipeCategory pCategory, UpgradeItemRecipe.CraftType type, ItemLike pResult, int pCount) {
        return new UpgradeRecipeBuilder(pCategory, type, pResult, pCount);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.advancement.addCriterion(name, criterion);
        return this;
    }

    public UpgradeRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public UpgradeRecipeBuilder source(Ingredient ingredient) {
        this.source = ingredient;
        return this;
    }

    public UpgradeRecipeBuilder source(DeferredItem<? extends Item> registryObject) {
        this.source(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        return this;
    }

    public UpgradeRecipeBuilder source(Item item) {
        this.source(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public UpgradeRecipeBuilder material(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public UpgradeRecipeBuilder material(DeferredItem<? extends Item> registryObject) {
        this.material(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
        return this;
    }

    public UpgradeRecipeBuilder material(Item item) {
        this.material(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        this.ensureValid(id);
        recipeOutput.accept(id, (Recipe)new UpgradeItemRecipe(RecipeBuilder.determineBookCategory((RecipeCategory)this.category), this.source, this.material, new ItemStack((ItemLike)this.result), this.group, this.type), this.advancement.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.material == null) {
            throw new IllegalStateException("material not defined in Upgrade recipe " + String.valueOf(pId) + "!");
        }
        if (this.source == null) {
            throw new IllegalStateException("source not defined in Upgrade recipe " + String.valueOf(pId) + "!");
        }
    }
}

