/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import java.util.List;
import java.util.Optional;
import net.kapitencraft.kap_lib.client.ExtraComponents;
import net.kapitencraft.kap_lib.cooldown.Cooldowns;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBlockBreakEffect;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBowEffect;
import net.kapitencraft.kap_lib.enchantments.extras.EnchantmentDescriptionManager;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.ParticleHelper;
import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.kapitencraft.kap_lib.io.network.S2C.SyncBonusesPacket;
import net.kapitencraft.kap_lib.io.network.S2C.SyncRequirementsPacket;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraEnchantmentEffectComponents;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.kapitencraft.kap_lib.tags.ExtraTags;
import net.kapitencraft.kap_lib.util.attribute.TimedModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber
@ApiStatus.Internal
public class Events {
    private static final List<Class<? extends LivingEvent>> dontCancel = List.of(ItemTooltipEvent.class, RenderPlayerEvent.Pre.class, RenderPlayerEvent.Post.class, PlayerEvent.LoadFromFile.class, PlayerEvent.NameFormat.class, PlayerEvent.TabListNameFormat.class, PlayerEvent.PlayerLoggedInEvent.class, PlayerEvent.PlayerLoggedOutEvent.class, MovementInputUpdateEvent.class, LivingBreatheEvent.class);
    public static final String DOUBLE_JUMP_ID = "currentDoubleJump";

    @SubscribeEvent
    public static void addRequirementListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RequirementManager.instance);
        event.addListener((PreparableReloadListener)BonusManager.updateInstance());
    }

    @SubscribeEvent
    public static void appendPlayerHead(PlayerEvent.NameFormat event) {
        event.setDisplayname((Component)ExtraComponents.playerHead(event.getEntity().getUUID()).append(event.getDisplayname()));
    }

    @SubscribeEvent
    public static void playerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncRequirementsPacket(RequirementManager.createData()), (CustomPacketPayload[])new CustomPacketPayload[]{new SyncBonusesPacket(BonusManager.instance.createData())});
        }
    }

    @SubscribeEvent
    public static void addReqDisplay(ItemTooltipEvent event) {
        ClientHelper.addReqContent(event.getToolTip()::add, RegistryReqType.ITEM, event.getItemStack().getItem(), (LivingEntity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void healingDisplay(LivingHealEvent event) {
        if (event.getAmount() > 0.0f) {
            MiscHelper.createDamageIndicator(event.getEntity(), event.getAmount(), "heal");
        }
    }

    @SubscribeEvent
    public static void modArrowEnchantments(ArrowLooseEvent event) {
        event.setCharge((int)((double)event.getCharge() * event.getEntity().getAttributeValue(ExtraAttributes.DRAW_SPEED) / 100.0));
    }

    @SubscribeEvent
    public static void joinLevelEvent(EntityJoinLevelEvent event) {
        Entity serverLevel;
        AbstractArrow arrow;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)entity;
            Entity entity2 = arrow.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                ItemStack bow = living.getUseItem();
                CompoundTag arrowTag = arrow.getPersistentData();
                if (bow.is(ExtraTags.Items.HITS_ENDERMAN)) {
                    arrowTag.putBoolean("HitsEnderMan", true);
                }
                EnchantedItemInUse itemInUse = new EnchantedItemInUse(bow, living.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, living);
                EnchantmentHelper.runIterationOnItem((ItemStack)bow, (arg_0, arg_1) -> Events.lambda$joinLevelEvent$1((ServerLevel)serverLevel, arrow, itemInUse, bow, living, arg_0, arg_1));
            }
        }
        if ((serverLevel = event.getEntity()) instanceof Player) {
            Player player = (Player)serverLevel;
            AttributeInstance manaInst = player.getAttribute(ExtraAttributes.MANA);
            CompoundTag tag = player.getPersistentData();
            if (manaInst == null) {
                throw new IllegalStateException();
            }
            double mana = tag.contains("Mana", 6) ? tag.getDouble("Mana") : 100.0;
            manaInst.setBaseValue(mana);
            if (tag.contains("Health", 5)) {
                player.setHealth(tag.getFloat("Health"));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)player;
                Wearables.send(sP);
                Cooldowns.send(sP);
            } else {
                EnchantmentDescriptionManager.initApplication();
            }
        }
    }

    @SubscribeEvent
    public static void leaveLevelEvent(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getPersistentData().putDouble("Mana", player.getAttributeValue(ExtraAttributes.MANA));
        }
        if (event.getEntity().level().isClientSide()) {
            TerminatorTriggers.ENTITY_REMOVED.get().trigger(event.getEntity().getId());
        }
    }

    @SubscribeEvent
    public static void tickArrows(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            CompoundTag arrowTag = arrow.getPersistentData();
            EnchantmentBowEffect.loadFromTag(null, arrowTag, EnchantmentBowEffect.ExePhase.TICK, 0.0f, arrow);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void healthRegenRegister(LivingHealEvent event) {
        LivingEntity living = event.getEntity();
        if (living.getAttribute(ExtraAttributes.VITALITY) != null) {
            double vitality = living.getAttributeValue(ExtraAttributes.VITALITY);
            event.setAmount(event.getAmount() * (1.0f + (float)vitality / 100.0f));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        CompoundTag tag = player.getPersistentData();
        if (!player.onGround()) {
            if (Events.canJump(player) && (double)tag.getInt(DOUBLE_JUMP_ID) < player.getAttributeValue(ExtraAttributes.DOUBLE_JUMP) && player.jumping && player.noJumpDelay <= 0) {
                ParticleHelper.sendAlwaysVisibleParticles((ParticleOptions)ParticleTypes.CLOUD, player.level(), player.getX(), player.getY(), player.getZ(), 0.25, 0.0, 0.25, 0.0, 0.0, 0.0, 15);
                player.noJumpDelay = 10;
                player.fallDistance = 0.0f;
                Vec3 targetLoc = player.getLookAngle().multiply(1.0, 0.0, 1.0).scale(0.75).add(0.0, 1.0, 0.0);
                player.setDeltaMovement(targetLoc.x, targetLoc.y > 0.0 ? targetLoc.y : -targetLoc.y, targetLoc.z);
                player.hurtMarked = true;
                IOHelper.increaseIntegerTagValue(player.getPersistentData(), DOUBLE_JUMP_ID, 1);
            }
        } else if (tag.getInt(DOUBLE_JUMP_ID) > 0) {
            tag.putInt(DOUBLE_JUMP_ID, 0);
        }
    }

    @SubscribeEvent
    public static void entityTick(EntityTickEvent.Post event) {
        Mob mob;
        LivingEntity living;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).isDeadOrDying()) {
            return;
        }
        if (living instanceof Player) {
            Cooldowns.get(living).tick(living);
            TimedModifiers.get(living).tick(living);
        }
        if (living instanceof Mob && (mob = (Mob)living).getTarget() != null && mob.getTarget().isInvisible()) {
            mob.setTarget(null);
        }
    }

    private static boolean canJump(Player player) {
        return !player.onGround() && !player.isPassenger() && !player.getAbilities().flying && !player.isInWater() && !player.isInLava();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double scale = AttributeHelper.getExperienceScale(player);
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * scale));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ItemStack tool = player.getItemBySlot(EquipmentSlot.MAINHAND);
            if (!tool.isEmpty()) {
                MutableBoolean mutableBoolean = new MutableBoolean(false);
                BlockEntity blockEntity = level2.getBlockEntity(event.getPos());
                BlockState state = event.getState();
                LootParams.Builder builder = new LootParams.Builder(level2).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.TOOL, (Object)tool);
                if (blockEntity != null) {
                    builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
                }
                EnchantmentHelper.runIterationOnItem((ItemStack)tool, (holder, i) -> {
                    builder.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)i);
                    LootParams params = builder.create(EnchantmentBlockBreakEffect.PARAM_SET);
                    LootContext context = new LootContext.Builder(params).create(Optional.empty());
                    for (ConditionalEffect effect : ((Enchantment)holder.value()).getEffects((DataComponentType)ExtraEnchantmentEffectComponents.BLOCK_BREAK.get())) {
                        if (!effect.matches(context)) continue;
                        mutableBoolean.setValue(((EnchantmentBlockBreakEffect)effect.effect()).onBreak(state, event.getPos(), level2, i) || mutableBoolean.booleanValue());
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * AttributeHelper.getExperienceScale(player)));
        }
    }

    private static /* synthetic */ void lambda$joinLevelEvent$1(ServerLevel serverLevel, AbstractArrow arrow, EnchantedItemInUse itemInUse, ItemStack bow, LivingEntity living, Holder enchantment, int level) {
        LootContext context = Enchantment.entityContext((ServerLevel)serverLevel, (int)level, (Entity)arrow, (Vec3)arrow.position());
        ((Enchantment)enchantment.value()).getEffects((DataComponentType)ExtraEnchantmentEffectComponents.BOW_SPAWN.value()).forEach(enchantmentEntityEffect -> {
            if (enchantmentEntityEffect.matches(context)) {
                ((EnchantmentEntityEffect)enchantmentEntityEffect.effect()).apply(serverLevel, level, itemInUse, (Entity)arrow, arrow.position());
            }
        });
        ListTag list = IOHelper.getOrCreateList(arrow.getPersistentData(), enchantment.getKey().location().toString(), 10);
        List effects = ((Enchantment)enchantment.value()).getEffects((DataComponentType)ExtraEnchantmentEffectComponents.BOW.value());
        for (int i = 0; i < effects.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            ConditionalEffect effect = (ConditionalEffect)effects.get(i);
            if (effect.matches(context)) {
                ((EnchantmentBowEffect)effect.effect()).write(tag, level, bow, living, arrow);
            }
            list.add(i, (Tag)tag);
        }
    }
}

