/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.wrapper;

import com.mojang.datafixers.util.Pair;
import net.kapitencraft.kap_lib.mixin.duck.inventory.InventoryPageReader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotWrapper
extends Slot {
    protected final InventoryPageReader getter;
    private final int pageId;
    protected final Slot wrapped;

    public SlotWrapper(InventoryPageReader getter, int pageId, Slot wrapped) {
        super(wrapped.container, wrapped.getContainerSlot(), wrapped.x, wrapped.y);
        this.getter = getter;
        this.pageId = pageId;
        this.wrapped = wrapped;
    }

    public boolean isActive() {
        return this.pageId == this.getter.getPageIndex() && this.wrapped.isActive();
    }

    public boolean mayPlace(@NotNull ItemStack pStack) {
        return this.wrapped.mayPlace(pStack);
    }

    public boolean mayPickup(@NotNull Player pPlayer) {
        return this.wrapped.mayPickup(pPlayer);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return this.wrapped.getNoItemIcon();
    }

    public void setByPlayer(ItemStack pStack) {
        this.wrapped.setByPlayer(pStack);
    }

    public void onQuickCraft(ItemStack oldStack, ItemStack newStack) {
        this.wrapped.onQuickCraft(oldStack, newStack);
    }

    public void onTake(Player player, ItemStack stack) {
        this.wrapped.onTake(player, stack);
    }

    public int getContainerSlot() {
        return this.wrapped.getContainerSlot();
    }
}

