/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.test;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.inventory.wearable.WearableItem;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.item.ExtendedItem;
import net.kapitencraft.kap_lib.registry.TestCooldowns;
import net.kapitencraft.kap_lib.registry.custom.WearableSlots;
import net.kapitencraft.kap_lib.util.attribute.BaseAttributeLocations;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestItem
extends WearableItem
implements ExtendedItem {
    public TestItem() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getModifiers(WearableSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot.is(WearableSlots.BELT)) {
            multimap.put((Object)Attributes.LUCK, (Object)new AttributeModifier(BaseAttributeLocations.LUCK, 10.0, AttributeModifier.Operation.ADD_VALUE));
        }
        return multimap;
    }

    @Override
    public WearableSlot getSlot() {
        return (WearableSlot)WearableSlots.BELT.value();
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!((Cooldown)TestCooldowns.TEST.value()).isActive((LivingEntity)pPlayer)) {
            if (!pLevel.isClientSide()) {
                ((Cooldown)TestCooldowns.TEST.value()).applyCooldown((LivingEntity)pPlayer, false);
            }
            pPlayer.sendSystemMessage((Component)Component.literal((String)"started"));
            return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
        }
        pPlayer.sendSystemMessage((Component)Component.literal((String)"not work"));
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void appendHoverTextWithPlayer(@NotNull ItemStack itemStack, @Nullable Item.TooltipContext context, @NotNull List<Component> list, @NotNull TooltipFlag flag, Player player) {
        list.add(((Cooldown)TestCooldowns.TEST.value()).createDisplay((LivingEntity)player));
    }
}

