/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetFireFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<SetFireFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("visual", (Object)true).forGetter(f -> f.visualFire), (App)Codec.INT.fieldOf("duration").forGetter(f -> f.duration)).and(SetFireFunction.commonFields(i).t1()).apply((Applicative)i, SetFireFunction::new));
    private final Boolean visualFire;
    private final int duration;

    protected SetFireFunction(Boolean visualFire, int duration, List<LootItemCondition> pPredicates) {
        super(pPredicates);
        this.visualFire = visualFire;
        this.duration = duration;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        pEntity.setRemainingFireTicks(this.duration);
        if (this.visualFire != null) {
            pEntity.hasVisualFire = this.visualFire;
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return SpawnEntityFunctions.SET_FIRE_DURATION.get();
    }
}

