/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetNameFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<SetNameFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ComponentSerialization.CODEC.fieldOf("name").forGetter(f -> f.name)).and(SetNameFunction.commonFields(i).t1()).apply((Applicative)i, SetNameFunction::new));
    private final Component name;

    public SetNameFunction(Component name, List<LootItemCondition> conditions) {
        super(conditions);
        this.name = name;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.SET_NAME.get();
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        pEntity.setCustomName(this.name);
        pEntity.setCustomNameVisible(true);
        return pEntity;
    }

    public static Builder setName(Component component) {
        return new Builder(component);
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private final Component name;

        Builder(Component name) {
            this.name = name;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new SetNameFunction(this.name, this.getConditions());
        }
    }
}

