package net.kapitencraft.kap_lib.data_gen;

import net.kapitencraft.kap_lib.data_gen.tags.ModTagsProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

import java.util.concurrent.CompletableFuture;

@EventBusSubscriber
public class Generator {

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        lookupProvider = generator.addProvider(true, new ModRegistriesProvider(output, lookupProvider)).getRegistryProvider();
        generator.addProvider(true, new ExtraNumbersLangProvider(output));
        CompletableFuture<TagsProvider.TagLookup<Block>> blockTagLookup = generator.addProvider(true, new ModTagsProvider.Block(output, lookupProvider, helper)).contentsGetter();
        generator.addProvider(true, new ModTagsProvider.EntityTypes(output, lookupProvider));
        generator.addProvider(true, new ModTagsProvider.DamageType(output, lookupProvider, helper));
        generator.addProvider(true, new TestSpawnTableProvider(output, lookupProvider));
        generator.addProvider(true, new TestBonusProvider(output, lookupProvider, helper));
        generator.addProvider(true, new TestLanguageProvider(output));
        generator.addProvider(false, new ModLanguageProvider(output));
        generator.addProvider(false, new TestRecipeProvider(output, lookupProvider));
        generator.addProvider(true, new TestImageMapper(helper, output));
    }
}
