/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.gui.screen.MenuableScreen;
import net.kapitencraft.kap_lib.client.overlay.OverlayController;
import net.kapitencraft.kap_lib.client.overlay.box.InteractiveBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.MultiElementSelectorElement;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ChangeOverlayLocationsScreen
extends MenuableScreen {
    private final OverlayController controller = LibClient.controller;
    private final List<InteractiveBox> boxes = new ArrayList<InteractiveBox>();

    public ChangeOverlayLocationsScreen() {
        super((Component)Component.m_237115_((String)"change_overlay_locations.title"));
        this.setDefaultMenuBuilder((x, y) -> {
            DropDownMenu menu = new DropDownMenu(x, y, (GuiEventListener)this);
            menu.addElement(MultiElementSelectorElement.builder(Overlay.class).setElements(this.controller.map.values()).setStatusMapper(Overlay::isVisible).setNameMapper(Overlay::getName).setOnChange(Overlay::setVisible));
            return menu;
        });
    }

    protected void m_7856_() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        this.boxes.clear();
        this.controller.fillRenderBoxes(this.boxes::add, player, this.f_96547_, this.f_96543_, this.f_96544_);
        super.m_7856_();
    }

    @NotNull
    public List<InteractiveBox> m_6702_() {
        return this.boxes;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        List<InteractiveBox> list = this.getHovering(pMouseX, pMouseY);
        list.forEach(interactiveBox -> interactiveBox.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY));
        return !list.isEmpty();
    }

    public boolean m_6348_(double x, double y, int z) {
        List<InteractiveBox> list = this.getHovering(x, y);
        list.forEach(interactiveBox -> interactiveBox.mouseRelease(x, y));
        return !list.isEmpty();
    }

    private List<InteractiveBox> getHovering(double x, double y) {
        return this.boxes.stream().filter(interactiveBox -> interactiveBox.m_5953_(x, y)).toList();
    }

    @Override
    public void m_94757_(double x, double y) {
        super.m_94757_(x, y);
        this.getHovering(x, y).forEach(interactiveBox -> interactiveBox.mouseMove(x, y));
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        this.boxes.forEach(interactiveBox -> interactiveBox.render(graphics, mouseX, mouseY));
        super.m_88315_(graphics, mouseX, mouseY, pPartialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, -11579569);
        int arrowId = this.boxes.stream().map(box -> box.getCursorType(mouseX, mouseY)).filter(i -> i != 221185).findFirst().orElse(221185);
        ClientHelper.changeCursorType(arrowId);
    }

    public void m_7379_() {
        OverlayController.save();
        super.m_7379_();
    }
}

