/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation;

import java.util.List;
import java.util.Map;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimationParameters;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimations;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.particle.Particle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleAnimationController {
    private final List<Particle> toAnimate;
    private boolean done = false;
    private final Map<Integer, ParticleAnimations> animationsForTime;
    private final ParticleAnimationParameters parameters;
    int startTime = -1;

    public ParticleAnimationController(List<Particle> toAnimate, Map<Integer, ParticleAnimations> animationsForTime, ParticleAnimationParameters parameters) {
        this.toAnimate = toAnimate;
        this.animationsForTime = animationsForTime;
        this.toAnimate.forEach(particle -> particle.m_107257_(this.animationLength() + 1));
        this.parameters = parameters;
        this.toAnimate.forEach(particle -> particle.m_107257_(this.animationLength()));
    }

    public ParticleAnimationParameters getParameters() {
        return this.parameters;
    }

    public boolean mergeable(ParticleAnimationController controller) {
        return controller.parameters == this.parameters && controller.animationsForTime.equals(this.animationsForTime);
    }

    public boolean equals(Object obj) {
        ParticleAnimationController controller;
        return obj instanceof ParticleAnimationController && this.mergeable(controller = (ParticleAnimationController)obj) && controller.toAnimate.equals(this.toAnimate);
    }

    public void merge(ParticleAnimationController controller) {
        if (this.mergeable(controller)) {
            this.toAnimate.addAll(controller.toAnimate);
            controller.done = true;
        }
    }

    public void animate(int time) {
        ParticleAnimations animation = this.forTimeStamp(time, this.parameters);
        if (animation != null && animation.test(this.parameters)) {
            this.toAnimate.forEach(particle -> animation.test(this.parameters));
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean done(int time) {
        return this.isDone() || time >= this.animationLength();
    }

    private ParticleAnimations forTimeStamp(int time, ParticleAnimationParameters context) {
        for (Map.Entry<Integer, ParticleAnimations> entry : this.animationsForTime.entrySet()) {
            if (entry.getKey() > time) {
                context.remainingAnimTime = entry.getKey() - time;
                return entry.getValue();
            }
            time -= entry.getKey().intValue();
        }
        return null;
    }

    private int animationLength() {
        return MathHelper.count(this.animationsForTime.keySet());
    }
}

