/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimParam;
import net.minecraft.network.FriendlyByteBuf;

public class ParticleAnimationParameters {
    int remainingAnimTime = -1;
    private final HashMap<ParticleAnimParam<?>, Object> params = new HashMap();

    public static ParticleAnimationParameters create() {
        return new ParticleAnimationParameters();
    }

    public <T> ParticleAnimationParameters withParam(ParticleAnimParam<T> paramKey, T paramValue) {
        this.params.put(paramKey, paramValue);
        return this;
    }

    public <T> boolean hasParam(ParticleAnimParam<T> key) {
        return this.params.containsKey(key);
    }

    public boolean containsAll(ParticleAnimParam<?> ... keys) {
        return Arrays.stream(keys).allMatch(this.params::containsKey);
    }

    public <T> Optional<T> getParam(ParticleAnimParam<T> param) {
        if (this.params.containsKey(param)) {
            try {
                Object t = this.params.get(param);
                return Optional.of(t);
            }
            catch (ClassCastException e) {
                KapLibMod.LOGGER.warn(Markers.PARTICLE_ENGINE, "error getting interactive particle param: {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    public <T> T getParamOrThrow(ParticleAnimParam<T> param) {
        try {
            return (T)this.params.get(param);
        }
        catch (Exception e) {
            throw new NoSuchElementException("the animation parameters do not contain param " + param);
        }
    }

    public void writeToNetwork(FriendlyByteBuf buf) {
        this.params.forEach((interactiveParticleContextParam, o) -> interactiveParticleContextParam.accept(buf, o));
    }

    public static ParticleAnimationParameters loadFromNetwork(FriendlyByteBuf buf) {
        ParticleAnimationParameters context = new ParticleAnimationParameters();
        context.readFromNetwork(buf);
        return context;
    }

    public void readFromNetwork(FriendlyByteBuf buf) {
        try {
            while (true) {
                ParticleAnimParam<?> param = ParticleAnimParam.getParam(buf.m_130277_());
                this.params.put(param, param.apply(buf));
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

