/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements;

import java.util.function.Consumer;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.widget.menu.IValueModifierElement;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.Element;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.ListElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class BooleanElement
extends Element
implements IValueModifierElement<BooleanElement, Boolean> {
    private final Consumer<Boolean> onChange;
    private boolean selected = false;

    protected BooleanElement(ListElement parent, DropDownMenu menu, Component name, Consumer<Boolean> onChange) {
        super(parent, menu, name);
        this.onChange = onChange;
    }

    public boolean selected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.onChange.accept(this.selected);
    }

    @Override
    protected int width() {
        return super.width() + 9;
    }

    @Override
    public void click(float relativeX, float relativeY) {
        this.setSelected(!this.selected());
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.selected()) {
            int checkBoxX = this.x + this.effectiveWidth() - 9;
            int checkBoxY = this.y + 1;
            UsefulTextures.renderCheckMark(graphics, checkBoxX, checkBoxY);
        }
    }

    @Override
    public void setValue(Boolean value) {
        this.selected = value;
    }

    public static class Builder
    extends Element.Builder<BooleanElement, Builder> {
        private Consumer<Boolean> onChange;

        public Builder setOnChange(Consumer<Boolean> onChange) {
            this.onChange = onChange;
            return this;
        }

        @Override
        public BooleanElement build(ListElement element, DropDownMenu menu) {
            Validate.notNull(this.onChange, (String)"onChange may not be null", (Object[])new Object[0]);
            return new BooleanElement(element, menu, this.name, this.onChange);
        }
    }
}

