/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.config;

import java.util.Arrays;
import net.kapitencraft.kap_lib.client.chroma.ChromaOrigin;
import net.kapitencraft.kap_lib.client.chroma.ChromaType;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.Element;
import net.minecraft.ChatFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kap_lib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.DoubleValue SCROLL_SCALE;
    private static final ForgeConfigSpec.EnumValue<Element.FocusTypes> FOCUS_TYPE;
    private static final ForgeConfigSpec.DoubleValue CHROMA_SPEED;
    private static final ForgeConfigSpec.EnumValue<ChromaType> CHROMA_TYPE;
    private static final ForgeConfigSpec.DoubleValue CHROMA_SPACING;
    private static final ForgeConfigSpec.EnumValue<ChromaOrigin> CHROMA_ORIGIN;
    private static final ForgeConfigSpec.EnumValue<ChatFormatting> PING_COLOR;
    private static final ForgeConfigSpec.IntValue CURSOR_MOVE_OFFSET;
    public static final ForgeConfigSpec SPEC;

    public static ChatFormatting getPingColor() {
        return (ChatFormatting)PING_COLOR.get();
    }

    public static double getScrollScale() {
        return (Double)SCROLL_SCALE.get();
    }

    public static int getCursorMoveOffset() {
        return (Integer)CURSOR_MOVE_OFFSET.get();
    }

    public static ChromaType getChromaType() {
        return (ChromaType)CHROMA_TYPE.get();
    }

    public static float getChromaSpeed() {
        return (float)((Double)CHROMA_SPEED.get()).doubleValue();
    }

    public static float getChromaSpacing() {
        return (float)((Double)CHROMA_SPACING.get()).doubleValue();
    }

    public static Element.FocusTypes getFocusType() {
        return (Element.FocusTypes)((Object)FOCUS_TYPE.get());
    }

    public static ChromaOrigin getChromaOrigin() {
        return (ChromaOrigin)CHROMA_ORIGIN.get();
    }

    static {
        BUILDER.comment("settings for GUI elements").push("gui");
        SCROLL_SCALE = BUILDER.comment("the scale of how quick tooltips are scrolled with").defineInRange("scroll_scale", 5.0, 1.0, 100.0);
        FOCUS_TYPE = BUILDER.comment("what focus type should be used for highlighting").defineEnum("focus_type", (Enum)Element.FocusTypes.OUTLINE);
        CURSOR_MOVE_OFFSET = BUILDER.comment("how many lines below the top the cursor will start scrolling up").defineInRange("cursor_move_offset", 2, 0, 5);
        BUILDER.pop().comment("data to determine how chroma text should be rendered [WIP]").push("chroma");
        CHROMA_SPEED = BUILDER.comment("the speed of chroma").defineInRange("speed", 4.0, 1.0, 50.0);
        CHROMA_TYPE = BUILDER.comment("the type of chroma ").defineEnum("type", (Enum)ChromaType.LINEAR);
        CHROMA_SPACING = BUILDER.comment("how wide each color should be rendered\nwith large values = less spread").defineInRange("spacing", 10.0, 0.5, 50.0);
        CHROMA_ORIGIN = BUILDER.comment("where the origin of the chroma (eg it's rotation and animation direction) should be").defineEnum("origin", (Enum)ChromaOrigin.BOTTOM_RIGHT);
        BUILDER.pop();
        PING_COLOR = BUILDER.comment("determines the color which indicates pings").defineEnum("ping_color", (Enum)ChatFormatting.YELLOW, (Enum[])((ChatFormatting[])Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).toArray(ChatFormatting[]::new)));
        SPEC = BUILDER.build();
    }
}

