/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CompoundPath(String path, CompoundPath parent) {
    public static final CompoundPath ROOT = new CompoundPath("", null);
    public static final CompoundPath COOLDOWN = new CompoundPath("Cooldowns", ROOT);

    @NotNull
    public CompoundTag getOrCreateTag(Entity entity) {
        if (this == ROOT) {
            return entity.getPersistentData();
        }
        CompoundTag parentPath = this.parent.getOrCreateTag(entity);
        if (!parentPath.m_128425_(this.path, 10)) {
            CompoundTag tag = new CompoundTag();
            parentPath.m_128365_(this.path, (Tag)tag);
            return tag;
        }
        return parentPath.m_128469_(this.path);
    }

    @Nullable
    public CompoundTag getTag(Entity entity) {
        if (this == ROOT) {
            return entity.getPersistentData();
        }
        CompoundTag parentPath = this.parent.getTag(entity);
        if (parentPath != null && parentPath.m_128425_(this.path, 10)) {
            return parentPath.m_128469_(this.path);
        }
        return null;
    }

    public static Builder builder(String path) {
        return new Builder(path);
    }

    public static class Builder {
        private final String path;
        private CompoundPath parent;

        public Builder(String path) {
            this.path = path;
        }

        public Builder withParent(CompoundPath parent) {
            this.parent = parent;
            return this;
        }

        public Builder withParentIfNull(CompoundPath parent) {
            if (this.parent == null) {
                this.parent = parent;
            }
            return this;
        }

        public Builder withParent(String id, Consumer<Builder> consumer) {
            Builder builder = new Builder(id);
            consumer.accept(builder);
            this.parent = builder.build();
            return this;
        }

        public CompoundPath build() {
            return new CompoundPath(this.path, this.parent == null ? ROOT : this.parent);
        }
    }
}

