/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import java.util.function.Consumer;
import net.kapitencraft.kap_lib.cooldown.CompoundPath;
import net.kapitencraft.kap_lib.cooldown.ICooldownable;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.registry.ModAttributes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import org.jetbrains.annotations.NotNull;

public class Cooldown {
    private final CompoundPath path;
    private final int defaultTime;
    private final Consumer<LivingEntity> toDo;

    public Cooldown(CompoundPath.Builder path, int defaultTime, Consumer<LivingEntity> toDo) {
        this.path = path.withParentIfNull(CompoundPath.COOLDOWN).build();
        this.defaultTime = defaultTime;
        this.toDo = toDo;
    }

    public void applyCooldown(LivingEntity living, boolean reduceWithTime) {
        CompoundTag tag = this.getTag((Entity)living);
        double mul = reduceWithTime ? living.m_21133_((Attribute)ModAttributes.COOLDOWN_REDUCTION.get()) : 0.0;
        int value = (int)((double)this.defaultTime * (1.0 - mul / 100.0));
        if (value > 0) {
            tag.m_128405_(this.path.path(), value);
            Cooldown.cast(living).addCooldown(this);
        }
    }

    private static ICooldownable cast(LivingEntity living) {
        return (ICooldownable)living;
    }

    public int getCooldownTime(Entity living) {
        CompoundTag tag = this.getTag(living);
        return tag.m_128451_(this.path.path());
    }

    public boolean isActive(Entity entity) {
        return this.getCooldownTime(entity) > 0;
    }

    public void onDone(LivingEntity living) {
        this.toDo.accept(living);
    }

    public CompoundPath getPath() {
        return this.path.parent();
    }

    public String getId() {
        return this.path.path();
    }

    @NotNull
    public CompoundTag getTag(Entity entity) {
        return this.path.parent().getOrCreateTag(entity);
    }

    public Component createDisplay(Entity entity) {
        int n;
        int cooldownTicks = this.getCooldownTime(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            n = MathHelper.cooldown(living, this.defaultTime);
        } else {
            n = this.defaultTime;
        }
        int defaultTime = n;
        return Component.m_237113_((String)("Cooldown: " + (cooldownTicks > 0 ? TextHelper.wrapInRed("ACTIVE ") + "(" + MathHelper.round((double)cooldownTicks / 20.0, 1) + "s)" : "\u00a7aINACTIVE\u00a7r, " + MathHelper.round((double)defaultTime / 20.0, 1) + "s"))).m_130940_(ChatFormatting.DARK_GRAY);
    }
}

