/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.cooldown.CompoundPath;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.minecraft.world.entity.LivingEntity;

public class MappedCooldown<T> {
    private final Map<T, Cooldown> mapped = new HashMap<T, Cooldown>();
    private final String path;
    private final Function<T, String> mapper;
    @Nullable
    private final Consumer<LivingEntity> exe;

    public MappedCooldown(String path, Function<T, String> mapper, @Nullable Consumer<LivingEntity> exe) {
        this.path = path;
        this.mapper = mapper;
        this.exe = exe;
    }

    @Nullable
    public Cooldown get(T t) {
        return this.mapped.get(t);
    }

    public Cooldown getOrCreate(T t, int time) {
        if (this.get(t) == null) {
            this.add(t, time);
        }
        return this.get(t);
    }

    public void add(T t, int time) {
        CompoundPath path = new CompoundPath(this.path, CompoundPath.COOLDOWN);
        this.mapped.put(t, new Cooldown(CompoundPath.builder(this.mapper.apply(t)).withParent(path), time, this.exe == null ? entity -> {} : this.exe));
    }
}

