/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface InventoryHelper {
    public static boolean hasPlayerStackInInventory(Player player, Item item) {
        Inventory inventory = player.m_150109_();
        return InventoryHelper.allInventory(inventory).stream().anyMatch(stack -> !stack.m_41619_() && stack.m_150930_(item));
    }

    public static void forInventory(Inventory inventory, Consumer<ItemStack> consumer) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            consumer.accept(inventory.m_8020_(i));
        }
    }

    public static Map<Integer, ItemStack> getAllContent(Inventory inventory) {
        HashMap<Integer, ItemStack> data = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            data.put(i, inventory.m_8020_(i));
        }
        return data;
    }

    public static List<ItemStack> allInventory(Inventory inventory) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        InventoryHelper.forInventory(inventory, list::add);
        return list;
    }

    public static boolean removeFromInventory(ItemStack stack, Player player) {
        Inventory inventory = player.m_150109_();
        InventoryHelper.forInventory(inventory, stack1 -> {
            if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1) && stack.m_41613_() > 0) {
                int size = Math.min(stack1.m_41613_(), stack.m_41613_());
                stack1.m_41774_(size);
                stack.m_41774_(size);
            }
        });
        return stack.m_41613_() <= 0;
    }

    public static int getFirstInventoryIndex(Item item, Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !currentStack.m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getFirstStackInventoryIndex(Player player, Item item) {
        return InventoryHelper.allInventory(player.m_150109_()).stream().filter(InventoryHelper.byItem(item)).findFirst().orElse(ItemStack.f_41583_);
    }

    public static Collection<ItemStack> getByFilter(Player player, Predicate<ItemStack> predicate) {
        return InventoryHelper.getContentByFilter(player, predicate).values();
    }

    public static Map<Integer, ItemStack> getContentByFilter(Player player, Predicate<ItemStack> predicate) {
        HashMap<Integer, ItemStack> itemStacks = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!predicate.test(stack)) continue;
            itemStacks.put(i, stack);
        }
        return itemStacks;
    }

    private static Predicate<ItemStack> byItem(Item item) {
        return stack -> stack.m_150930_(item);
    }

    public static boolean hasSetInInventory(Player player, ArmorMaterial material) {
        ArrayList slots = new ArrayList();
        InventoryHelper.allInventory(player.m_150109_()).stream().map(ItemStack::m_41720_).filter(item -> {
            ArmorItem armorItem;
            return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == material;
        }).map(ArmorItem.class::cast).map(ArmorItem::m_40402_).forEach(slots::add);
        return !slots.isEmpty() && new HashSet(slots).containsAll(Arrays.stream(MiscHelper.ARMOR_EQUIPMENT).toList());
    }

    public static boolean hasInInventory(List<ItemStack> content, Player player) {
        return InventoryHelper.getRemaining(content, player).isEmpty();
    }

    public static List<ItemStack> getRemaining(List<ItemStack> content, Player player) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : content) {
            Collection<ItemStack> list = InventoryHelper.getByFilter(player, stack1 -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1));
            list.forEach(stack1 -> stack.m_41774_(stack1.m_41613_()));
            if (stack.m_41613_() <= 0) continue;
            ret.add(stack);
        }
        return ret;
    }
}

