/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.serialization;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import org.jetbrains.annotations.NotNull;

public abstract class Serializer<T, K extends DynamicOps<T>, L> {
    private final K generator;
    private final Codec<L> codec;
    private final Supplier<L> defaulted;

    public Serializer(K generator, Codec<L> codec, Supplier<L> defaulted) {
        this.generator = generator;
        this.codec = codec;
        this.defaulted = defaulted;
    }

    abstract T getSerializeDefault();

    public T serialize(@NotNull L value) {
        return (T)IOHelper.get(this.codec.encodeStart(this.generator, value), this::getSerializeDefault);
    }

    public L deserialize(T object) {
        if (object == null) {
            return this.defaulted.get();
        }
        return (L)IOHelper.get(this.codec.parse(this.generator, object), MiscHelper.nonNullOr(this.defaulted, () -> null));
    }
}

