/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.registry.custom.ModRequirementTypes;
import net.kapitencraft.kap_lib.requirements.type.abstracts.CountCondition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class StatReqCondition
extends CountCondition<StatReqCondition> {
    private static final Map<StatType<?>, Function<?, Component>> STATS_TO_NAME_MAPPER = StatReqCondition.createStats();
    protected static final Codec<Stat<?>> STAT_CODEC = Codec.STRING.xmap(StatReqCondition::getStatFromSerializedName, StatReqCondition::getStatSerializedName);
    public static final Codec<StatReqCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)STAT_CODEC.fieldOf("stat").forGetter(s -> s.stat), (App)Codec.INT.fieldOf("minCount").forGetter(rec$ -> ((StatReqCondition)rec$).getMinLevel())).apply((Applicative)instance, StatReqCondition::new));
    protected final Stat<?> stat;

    private static Map<StatType<?>, Function<?, Component>> createStats() {
        HashMap map = new HashMap();
        StatReqCondition.appendStat(map, Stats.f_12949_, Block::m_49954_);
        StatReqCondition.appendStat(map, Stats.f_12982_, Item::m_41466_);
        StatReqCondition.appendStat(map, Stats.f_12984_, Item::m_41466_);
        StatReqCondition.appendStat(map, Stats.f_12981_, Item::m_41466_);
        StatReqCondition.appendStat(map, Stats.f_12986_, EntityType::m_20676_);
        return map;
    }

    private static <T> void appendStat(Map<StatType<?>, Function<?, Component>> map, StatType<T> stat, Function<T, Component> mapper) {
        map.put(stat, mapper);
    }

    private static <T> Component readComponent(Stat<?> stat, StatType<?> type, Function<?, Component> mapper) {
        return StatReqCondition.createComponent(stat, type, mapper);
    }

    private static <T> Component createComponent(Stat<?> stat, StatType<T> otherType, Function<T, Component> mapper) {
        StatType type = stat.m_12859_();
        if (type == otherType) {
            Object t = stat.m_12867_();
            return mapper.apply(t);
        }
        return null;
    }

    private static <T> String getStatSerializedName(Stat<T> stat) {
        return Stat.m_12862_((StatType)stat.m_12859_(), (Object)stat.m_12867_());
    }

    private static <T> Stat<T> getStatFromSerializedName(String statName) {
        String[] split = statName.split(":");
        ResourceLocation statTypeLoc = ResourceLocation.m_135822_((String)split[0], (char)'.');
        StatType type = (StatType)ForgeRegistries.STAT_TYPES.getValue(statTypeLoc);
        if (type == null) {
            throw new IllegalArgumentException("stat type '" + statTypeLoc + "' does not exist");
        }
        ResourceLocation statElementLoc = ResourceLocation.m_135822_((String)split[1], (char)'.');
        Object value = type.m_12893_().m_7745_(statElementLoc);
        if (value == null) {
            throw new IllegalArgumentException("stat element '" + statElementLoc + "' does not exist");
        }
        return type.m_12902_(value);
    }

    public StatReqCondition(Stat<?> stat, int level) {
        super((Player value) -> {
            int n;
            if (value instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)value;
                n = player.m_8951_().m_13015_(stat);
            } else {
                n = ((LocalPlayer)value).m_108630_().m_13015_(stat);
            }
            return n;
        }, level);
        this.stat = stat;
    }

    private <T> Component forStatType(Stat<T> stat) {
        StatType type = stat.m_12859_();
        for (Map.Entry<StatType<?>, Function<?, Component>> entry : STATS_TO_NAME_MAPPER.entrySet()) {
            Component component = StatReqCondition.readComponent(stat, entry.getKey(), entry.getValue());
            if (component == null) continue;
            return component;
        }
        return null;
    }

    @Override
    public DataGenSerializer<StatReqCondition> getSerializer() {
        return (DataGenSerializer)ModRequirementTypes.STAT_REQ.get();
    }

    @Override
    protected void additionalToNetwork(FriendlyByteBuf buf) {
        buf.m_130070_(StatReqCondition.getStatSerializedName(this.stat));
        buf.writeInt(this.minLevel);
    }

    public static StatReqCondition fromNetwork(FriendlyByteBuf buf) {
        return new StatReqCondition(StatReqCondition.getStatFromSerializedName(buf.m_130277_()), buf.readInt());
    }

    private Stat<?> getStat() {
        return this.stat;
    }

    @Override
    public Component getCountedDisplay() {
        return Component.m_237110_((String)("stat_req." + this.getTranslationKey()), (Object[])new Object[]{this.minLevel, this.forStatType(this.stat)});
    }

    private String getTranslationKey() {
        return Objects.requireNonNull(ForgeRegistries.STAT_TYPES.getKey((Object)this.stat.m_12859_()), "unknown stat type: " + this.stat.m_12859_().getClass().getCanonicalName()).toString().replace(':', '.');
    }
}

