/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Compacting {
    private static final Map<Item, Result> resultCache = new HashMap<Item, Result>();

    public static Result tryCompact(Item in, ServerLevel level) {
        if (resultCache.containsKey(in)) {
            return resultCache.get(in);
        }
        RecipeManager manager = level.getRecipeManager();
        Optional smallRecipe = manager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)2, (int)2, Compacting.list(true, in)), (Level)level);
        Optional largeRecipe = manager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)3, (int)3, Compacting.list(false, in)), (Level)level);
        Result result = smallRecipe.isEmpty() && largeRecipe.isEmpty() ? Result.EMPTY : new Result(smallRecipe.map(craftingRecipe -> ((CraftingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess())).orElse(null), largeRecipe.map(craftingRecipe -> ((CraftingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess())).orElse(null));
        resultCache.put(in, result);
        return result;
    }

    private static List<ItemStack> list(boolean small, Item in) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < (small ? 4 : 9); ++i) {
            list.add(new ItemStack((ItemLike)in));
        }
        return list;
    }

    public static class Result {
        public static final Result EMPTY = new Result(null, null);
        @Nullable
        private final ItemStack small;
        @Nullable
        private final ItemStack large;

        private Result(@Nullable ItemStack small, @Nullable ItemStack large) {
            this.small = small;
            this.large = large;
        }

        public boolean successful() {
            return this.small != null || this.large != null;
        }

        public boolean isSmall() {
            return this.successful() && this.small != null;
        }

        public int getCountReq() {
            return this.small != null ? 4 : (this.large != null ? 9 : -1);
        }

        @Nullable
        public ItemStack result() {
            return this.small != null ? this.small : this.large;
        }

        @Nullable
        public ItemStack getSmall() {
            return this.small;
        }

        @Nullable
        public ItemStack getLarge() {
            return this.large;
        }
    }
}

