/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.io.serialization.RegistrySerializer;
import net.kapitencraft.kap_lib.requirements.conditions.StatReqCondition;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.CountCondition;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;

public class CustomStatReqCondition
extends CountCondition<CustomStatReqCondition> {
    private static final Codec<Stat<ResourceLocation>> STAT_CODEC = BuiltInRegistries.CUSTOM_STAT.byNameCodec().xmap(arg_0 -> ((StatType)Stats.CUSTOM).get(arg_0), Stat::getValue);
    private static final MapCodec<CustomStatReqCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)STAT_CODEC.fieldOf("stat").forGetter(i -> i.stat), (App)Codec.INT.fieldOf("amount").forGetter(i -> i.minLevel), (App)ComponentSerialization.CODEC.fieldOf("display").forGetter(ReqCondition::display)).apply((Applicative)instance, CustomStatReqCondition::create));
    private static final StreamCodec<RegistryFriendlyByteBuf, CustomStatReqCondition> STREAM_CODEC = StreamCodec.of(CustomStatReqCondition::toNetwork, CustomStatReqCondition::fromNetwork);
    public static RegistrySerializer<CustomStatReqCondition> SERIALIZER = new RegistrySerializer<CustomStatReqCondition>(CODEC, STREAM_CODEC);
    private final Stat<ResourceLocation> stat;
    private final Component component;

    private static CustomStatReqCondition create(Stat<ResourceLocation> stat, Integer integer, Component component) {
        return new CustomStatReqCondition(stat, (int)integer, component);
    }

    private CustomStatReqCondition(Stat<ResourceLocation> stat, int level, Component component) {
        super(StatReqCondition.createCountExtractor(stat), level);
        this.stat = stat;
        this.component = component;
    }

    public CustomStatReqCondition(Stat<ResourceLocation> stat, int level, String translateKey) {
        this(stat, level, (Component)Component.translatable((String)translateKey, (Object[])new Object[]{level}));
    }

    public CustomStatReqCondition(Supplier<ResourceLocation> statSup, int level, String translateKey) {
        this((Stat<ResourceLocation>)Stats.CUSTOM.get((Object)statSup.get()), level, translateKey);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buf, CustomStatReqCondition condition) {
        buf.writeResourceLocation(BuiltInRegistries.CUSTOM_STAT.getKey((Object)((ResourceLocation)condition.stat.getValue())));
        buf.writeInt(condition.minLevel);
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)condition.component);
    }

    public static CustomStatReqCondition fromNetwork(RegistryFriendlyByteBuf buf) {
        return new CustomStatReqCondition((Stat<ResourceLocation>)Stats.CUSTOM.get((Object)((ResourceLocation)BuiltInRegistries.CUSTOM_STAT.get(buf.readResourceLocation()))), buf.readInt(), (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf));
    }

    @Override
    public RegistrySerializer<CustomStatReqCondition> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Component getCountedDisplay() {
        return this.component;
    }
}

