/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class SetAttributesFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<SetAttributesFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.pair((Codec)Attribute.CODEC, Modifiers.CODEC).listOf().fieldOf("modifiers").forGetter(f -> f.data)).and(SetAttributesFunction.commonFields(i).t1()).apply((Applicative)i, SetAttributesFunction::new));
    private final List<Pair<Holder<Attribute>, Modifiers>> data;

    private SetAttributesFunction(List<Pair<Holder<Attribute>, Modifiers>> data, List<LootItemCondition> pPredicates) {
        super(pPredicates);
        this.data = data;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            for (Pair<Holder<Attribute>, Modifiers> pair : this.data) {
                try {
                    ((Modifiers)pair.getSecond()).apply(living.getAttribute((Holder)pair.getFirst()));
                }
                catch (Exception e) {
                    KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "unable to apply attribute modifiers for '{}': {}", (Object)((Holder)pair.getFirst()).getKey().location(), (Object)e.getMessage());
                }
            }
        } else {
            SetAttributesFunction.logWrongType("LivingEntity", pEntity);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.SET_ATTRIBUTES.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    private record Modifiers(List<AttributeModifier> modifiers, Double base) {
        public static final Codec<Modifiers> CODEC = RecordCodecBuilder.create(i -> i.group((App)AttributeModifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(Modifiers::modifiers), (App)Codec.DOUBLE.optionalFieldOf("base").forGetter(f -> Optional.ofNullable(f.base))).apply((Applicative)i, Modifiers::fromCodec));

        private static Modifiers fromCodec(List<AttributeModifier> attributeModifiers, Optional<Double> aDouble) {
            return new Modifiers(attributeModifiers, aDouble.orElse(null));
        }

        public void apply(AttributeInstance instance) {
            if (this.base != null) {
                instance.setBaseValue(this.base.doubleValue());
            }
            for (AttributeModifier modifier : this.modifiers) {
                instance.addPermanentModifier(modifier);
            }
        }
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private final Map<Holder<Attribute>, ModifiersBuilder> modifiers = new HashMap<Holder<Attribute>, ModifiersBuilder>();

        @Override
        protected Builder getThis() {
            return this;
        }

        public ModifiersBuilder withAttribute(Holder<Attribute> attribute) {
            this.modifiers.putIfAbsent(attribute, new ModifiersBuilder());
            return this.modifiers.get(attribute);
        }

        @Override
        public SpawnEntityFunction build() {
            return new SetAttributesFunction(this.makePairs(), this.getConditions());
        }

        private List<Pair<Holder<Attribute>, Modifiers>> makePairs() {
            return MapStream.of(this.modifiers).mapValues(ModifiersBuilder::createModifiers).toPairList();
        }

        public class ModifiersBuilder {
            private Double base = null;
            private final List<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();

            public ModifiersBuilder setBase(double base) {
                this.base = base;
                return this;
            }

            public ModifiersBuilder addModifier(AttributeModifier modifier) {
                this.modifiers.add(modifier);
                return this;
            }

            private Modifiers createModifiers() {
                return new Modifiers(this.modifiers, this.base);
            }

            public Builder end() {
                return Builder.this;
            }
        }
    }
}

