/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class ArmorModel
extends HumanoidModel<LivingEntity> {
    public final ModelPart leftBoot;
    public final ModelPart rightBoot;

    public ArmorModel(ModelPart pRoot) {
        super(pRoot);
        this.leftBoot = pRoot.getChild("left_boot");
        this.rightBoot = pRoot.getChild("right_boot");
    }

    public ArmorModel(ModelPart pRoot, Function<ResourceLocation, RenderType> pRenderType) {
        super(pRoot, pRenderType);
        this.leftBoot = pRoot.getChild("left_boot");
        this.rightBoot = pRoot.getChild("right_boot");
    }

    public void setAllVisible(boolean pVisible) {
        super.setAllVisible(pVisible);
        this.leftBoot.visible = pVisible;
        this.rightBoot.visible = pVisible;
    }

    public void partVisible(EquipmentSlot slot) {
        this.setAllVisible(false);
        switch (slot) {
            case HEAD: {
                this.head.visible = true;
                this.hat.visible = true;
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                break;
            }
            case LEGS: {
                this.leftLeg.visible = true;
                this.rightLeg.visible = true;
                break;
            }
            case FEET: {
                this.leftBoot.visible = true;
                this.rightBoot.visible = true;
            }
        }
    }

    public void setupAnim(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        float f = 1.0f;
        if (pEntity.getFallFlyingTicks() > 4) {
            f = (float)pEntity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightBoot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount / f;
        this.leftBoot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount / f;
        this.rightBoot.yRot = 0.005f;
        this.leftBoot.yRot = -0.005f;
        this.rightBoot.zRot = 0.005f;
        this.leftBoot.zRot = -0.005f;
        if (this.riding) {
            this.rightBoot.xRot = -1.4137167f;
            this.rightBoot.yRot = 0.31415927f;
            this.rightBoot.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
    }

    public void renderToBuffer(@NotNull PoseStack stack, @NotNull VertexConsumer consumer, int packedLight, int packedOverlay, int packedColor) {
        super.renderToBuffer(stack, consumer, packedLight, packedOverlay, packedColor);
        this.leftBoot.render(stack, consumer, packedLight, packedOverlay, packedColor);
        this.rightBoot.render(stack, consumer, packedLight, packedOverlay, packedColor);
    }
}

