/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.enchantment_color;

import com.mojang.serialization.Codec;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColor;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentGroup;
import net.kapitencraft.kap_lib.client.enchantment_color.LevelRange;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.custom.GlyphEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EnchantmentColorManager {
    static Codec<EnchantmentColorManager> CODEC = EnchantmentColor.CODEC.listOf().xmap(EnchantmentColorManager::new, EnchantmentColorManager::getColors);
    @ApiStatus.Internal
    private static EnchantmentColorManager instance = EnchantmentColorManager.load();
    private final List<EnchantmentColor> colors = new ArrayList<EnchantmentColor>();
    private final DoubleMap<Holder<Enchantment>, Integer, Style> cache = DoubleMap.create();
    private static File PERSISTENT_FILE;

    public static EnchantmentColorManager getInstance() {
        return instance;
    }

    public EnchantmentColorManager(List<EnchantmentColor> colors) {
        this.colors.addAll(colors);
    }

    @NotNull
    private static File getOrCreateFile() {
        if (PERSISTENT_FILE == null) {
            PERSISTENT_FILE = new File(KapLibMod.ROOT, "enchantment_colors_config.json");
        }
        return PERSISTENT_FILE;
    }

    private static EnchantmentColorManager createDefault() {
        return new EnchantmentColorManager(List.of(EnchantmentColor.create(I18n.get((String)"enchantment_colors.curse", (Object[])new Object[0]), List.of(), List.of(EnchantmentGroup.CURSE), null, Style.EMPTY.withColor(ChatFormatting.RED)), EnchantmentColor.create(I18n.get((String)"enchantment_colors.ultimate", (Object[])new Object[0]), List.of(), List.of(EnchantmentGroup.ULTIMATE), null, Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withBold(Boolean.valueOf(true))), EnchantmentColor.create(I18n.get((String)"enchantment_colors.max_level", (Object[])new Object[0]), List.of(), List.of(), new LevelRange(0, 0, true), Style.EMPTY.withColor(ChatFormatting.GOLD)), EnchantmentColor.create(I18n.get((String)"enchantment_colors.over_level", (Object[])new Object[0]), List.of(), List.of(), new LevelRange(1, 255, true), MiscHelper.withSpecial(Style.EMPTY, GlyphEffects.RAINBOW))));
    }

    public static EnchantmentColorManager load() {
        return IOHelper.loadFile(EnchantmentColorManager.getOrCreateFile(), CODEC, EnchantmentColorManager::createDefault);
    }

    public static void reset() {
        instance = EnchantmentColorManager.createDefault();
    }

    public static void reload() {
        instance = EnchantmentColorManager.load();
    }

    private List<EnchantmentColor> getColors() {
        return this.colors;
    }

    public static Style getStyle(Holder<Enchantment> enchantment, int level) {
        return instance.getStyleForInstance(enchantment, level);
    }

    private Style getStyleForInstance(Holder<Enchantment> enchantment, int level) {
        EnchantmentColor color;
        Style style = this.cache.get(enchantment, level);
        if (style != null) {
            return style;
        }
        Iterator<EnchantmentColor> iterator = this.colors.iterator();
        while (iterator.hasNext() && (style = (color = iterator.next()).getStyleForEnchantment(enchantment, level)) == null) {
        }
        this.cache.put(enchantment, level, style);
        return style;
    }

    @ApiStatus.Internal
    public void save(List<EnchantmentColor> colors) {
        if (!this.colors.equals(colors)) {
            this.colors.clear();
            this.colors.addAll(colors);
            IOHelper.saveFile(EnchantmentColorManager.getOrCreateFile(), CODEC, this);
            this.cache.clear();
        }
    }

    List<EnchantmentColor> getAllColors() {
        return this.colors;
    }
}

