/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.particle.DamageIndicatorParticleOptions;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageIndicatorParticle
extends Particle {
    public static final double MAX_MOVEMENT = 0.35;
    private static final char CRIT_CHAR = ' ';
    private float fadeout = -1.0f;
    private float prevFadeout = -1.0f;
    private final Font font;
    private final String text;
    private final int color;
    private final int darkColor;
    private float visualDY;
    private float prevVisualDY;
    private float visualDX;
    private float prevVisualDX;

    protected DamageIndicatorParticle(ClientLevel level, double x, double y, double z, double amount, double damageType, float rangeOffset) {
        super(level, x, y, z);
        this.font = Minecraft.getInstance().font;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        this.text = amount == 3.4028234663852886E38 ? "INFINITE" : KapLibMod.doubleFormat(amount);
        this.color = TextHelper.damageIndicatorColorFromDouble(damageType).getColor();
        this.setColor(FastColor.ARGB32.red((int)this.color), FastColor.ARGB32.green((int)this.color), FastColor.ARGB32.blue((int)this.color));
        this.darkColor = FastColor.ARGB32.color((int)255, (int)((int)(this.rCol * 0.25f)), (int)((int)(this.rCol * 0.25f)), (int)((int)((double)this.rCol * 0.25)));
        this.lifetime = ClientModConfig.getIndicatorLifetime();
        this.yd = rangeOffset;
        this.xd = Mth.nextDouble((RandomSource)KapLibMod.RANDOM_SOURCE, (double)-0.35, (double)0.35) * (double)rangeOffset;
    }

    public void render(@NotNull VertexConsumer consumer, @NotNull Camera camera, float partialTicks) {
        Vec3 camPos = camera.getPosition();
        float particleX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camPos.x());
        float particleY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camPos.y());
        float particleZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camPos.z());
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        poseStack.translate(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).length();
        double inc = Mth.clamp((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.translate(0.0, (1.0 + inc / 4.0) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        poseStack.mulPose(camera.rotation());
        poseStack.translate((1.0 + inc) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.scale(scale, -scale, -scale);
        float fadeout = Mth.lerp((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        poseStack.translate(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.scale(fadeout, fadeout, fadeout);
        poseStack.translate(0.0, -distanceFromCam / 10.0, 0.0);
        float x1 = 0.5f - (float)this.font.width(this.text) / 2.0f;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int light = 0xF000F0;
        this.font.drawInBatch(this.text, x1, 0.0f, this.color, false, poseStack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        poseStack.translate(1.0, 1.0, 0.03);
        this.font.drawInBatch(this.text, x1, 0.0f, this.darkColor, false, poseStack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        buffer.endBatch();
        poseStack.popPose();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.age > (float)this.lifetime - length ? ((float)this.lifetime - (float)this.age) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY = (float)((double)this.visualDY + this.yd);
            this.prevVisualDX = this.visualDX;
            this.visualDX = (float)((double)this.visualDX + this.xd);
            if (Math.sqrt(Mth.square((double)((double)this.visualDX * 1.5)) + (double)Mth.square((float)(this.visualDY - 1.0f))) < 0.9) {
                this.yd /= 2.0;
            } else {
                this.yd = 0.0;
                this.xd = 0.0;
            }
        }
    }

    public static class Provider
    implements ParticleProvider<DamageIndicatorParticleOptions> {
        @Nullable
        public DamageIndicatorParticle createParticle(@NotNull DamageIndicatorParticleOptions particleType, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (!ClientModConfig.isIndicatorEnabled()) {
                return null;
            }
            return new DamageIndicatorParticle(level, x, y, z, particleType.getDamage(), particleType.getDamageType(), particleType.getRangeOffset());
        }
    }
}

