/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public interface AnimationElement {
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimationElement> CODEC = ByteBufCodecs.registry(ExtraRegistries.Keys.MODIFIER_TYPES).dispatch(AnimationElement::getType, Type::codec);

    @NotNull
    public Type<? extends AnimationElement> getType();

    public int createLength(ParticleConfig var1);

    public void tick(ParticleConfig var1, int var2, double var3);

    default public void initialize(ParticleConfig object) {
    }

    default public void finalize(ParticleConfig config) {
    }

    public static interface Type<T extends AnimationElement> {
        public StreamCodec<? super RegistryFriendlyByteBuf, T> codec();
    }

    public static interface Builder {
        public AnimationElement build();
    }
}

