/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.util.rot_target;

import net.kapitencraft.kap_lib.client.util.rot_target.RotationTarget;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec2;

public class FromEntityRotationTarget
implements RotationTarget {
    private final int entityId;

    FromEntityRotationTarget(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public Vec2 get() {
        return ClientHelper.getEntity(this.entityId).getRotationVector();
    }

    @Override
    public RotationTarget.Types getType() {
        return RotationTarget.Types.FROM_ENTITY;
    }

    public static class Type
    implements RotationTarget.Type<FromEntityRotationTarget> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, FromEntityRotationTarget> STREAM_CODEC = ByteBufCodecs.INT.map(FromEntityRotationTarget::new, t -> t.entityId);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, FromEntityRotationTarget> codec() {
            return STREAM_CODEC;
        }
    }
}

