/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.loot_table.modifiers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.helpers.LootTableHelper;
import net.kapitencraft.kap_lib.helpers.RNGHelper;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddItemModifier
extends ModLootModifier
implements IConditional {
    public static final MapCodec<AddItemModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AddItemModifier.addItemCodecStart(inst).apply((Applicative)inst, (conditionsIn, item1, chance1, maxAmount1, tagOptional) -> new AddItemModifier((LootItemCondition[])conditionsIn, (Item)item1, chance1.floatValue(), (int)maxAmount1, tagOptional.orElse(null))));
    final Item item;
    final int maxAmount;
    float chance;
    @Nullable
    final DataComponentPatch components;

    protected static <T extends AddItemModifier> Products.P5<RecordCodecBuilder.Mu<T>, LootItemCondition[], Item, Float, Integer, Optional<DataComponentPatch>> addItemCodecStart(RecordCodecBuilder.Instance<T> instance) {
        return AddItemModifier.codecStart(instance).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.INT.optionalFieldOf("maxAmount", (Object)1).forGetter(m -> m.maxAmount)).and((App)DataComponentPatch.CODEC.optionalFieldOf("nbt").forGetter(m -> Optional.ofNullable(m.components)));
    }

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance, int maxAmount, @Nullable DataComponentPatch components) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
        this.maxAmount = maxAmount;
        this.components = components;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.addItem(arg_0 -> generatedLoot.add(arg_0), context, this.chance);
        return generatedLoot;
    }

    public void addItem(Consumer<ItemStack> consumer, LootContext context, float chance) {
        ItemStack stack = RNGHelper.calculateAndDontDrop(this.item, this.maxAmount, LootTableHelper.getLivingSource(context), chance);
        if (this.components != null) {
            stack.applyComponentsAndValidate(this.components);
        }
        if (stack != ItemStack.EMPTY) {
            consumer.accept(stack);
        }
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

