/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.mixin.duck.ScaledClientMotionPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientboundSetEntityMotionPacket.class})
public class ClientboundSetEntityMotionPacketMixin
implements ScaledClientMotionPacket {
    @Shadow
    private int xa;
    @Shadow
    private int ya;
    @Shadow
    private int za;
    @Unique
    private float deltaScale;

    @Inject(method={"<init>(ILnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void calculateScale(int pId, Vec3 pDeltaMovement, CallbackInfo ci, double d0, double d1, double d2, double d3) {
        this.deltaScale = MathHelper.getOversizeScale(pDeltaMovement, new Vec3(d1, d2, d3));
        this.xa = (int)(pDeltaMovement.x * (double)this.deltaScale * 8000.0);
        this.ya = (int)(pDeltaMovement.y * (double)this.deltaScale * 8000.0);
        this.za = (int)(pDeltaMovement.z * (double)this.deltaScale * 8000.0);
    }

    @ModifyConstant(method={"getXa", "getYa", "getZa"}, constant={@Constant(doubleValue=8000.0)})
    private double addDeltaScale(double constant) {
        return constant / (double)this.deltaScale;
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="TAIL")})
    private void readScaleFromNW(FriendlyByteBuf pBuffer, CallbackInfo ci) {
        this.deltaScale = pBuffer.readFloat();
        this.xa = pBuffer.readInt();
        this.ya = pBuffer.readInt();
        this.za = pBuffer.readInt();
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void addScaleToNW(FriendlyByteBuf pBuffer, CallbackInfo ci) {
        pBuffer.writeFloat(this.deltaScale);
        pBuffer.writeInt(this.xa);
        pBuffer.writeInt(this.ya);
        pBuffer.writeInt(this.za);
    }

    @Override
    public float getScale() {
        return this.deltaScale;
    }
}

