/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ModAttachmentTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ManaHandler {
    public static final String OVERFLOW_MANA_ID = "overflowMana";

    @SubscribeEvent
    public static void manaChange(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        AttributeInstance maxManaInstance = player.getAttribute(ExtraAttributes.MAX_MANA);
        if (!ManaHandler.isMagical((LivingEntity)player)) {
            throw new IllegalStateException("detected Player unable to use mana, expecting broken mod-state!");
        }
        double manaRegen = player.getAttributeValue(ExtraAttributes.MANA_REGEN);
        CompoundTag tag = player.getPersistentData();
        ManaHandler.growMana((LivingEntity)player, manaRegen);
    }

    public static boolean consumeMana(LivingEntity living, double manaToConsume) {
        if (!ManaHandler.hasMana(living, manaToConsume)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        if (manaToConsume > 0.0) {
            mana -= manaToConsume;
        }
        ManaHandler.setMana(living, mana);
        return true;
    }

    public static boolean hasMana(LivingEntity living, double manaToConsume) {
        if (manaToConsume <= 0.0) {
            return true;
        }
        if (!ManaHandler.isMagical(living)) {
            return false;
        }
        return ManaHandler.getMana(living) >= manaToConsume;
    }

    public static double getMana(LivingEntity living) {
        return (Double)living.getData(ModAttachmentTypes.MANA);
    }

    public static void setMana(LivingEntity living, double mana) {
        living.setData(ModAttachmentTypes.MANA, (Object)mana);
    }

    public static boolean growMana(LivingEntity living, double mana) {
        ManaHandler.setMana(living, ManaHandler.getMana(living) + mana);
        return ManaHandler.isMagical(living);
    }

    public static boolean isMagical(LivingEntity living) {
        return living.getAttributes().hasAttribute(ExtraAttributes.MAX_MANA);
    }
}

