/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.text.DecimalFormat;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.config.ServerModConfig;
import net.kapitencraft.kap_lib.helpers.CommandHelper;
import net.kapitencraft.kap_lib.registry.ModAttributes;
import net.kapitencraft.kap_lib.registry.ModParticleTypes;
import net.kapitencraft.kap_lib.registry.custom.ModRequirementTypes;
import net.kapitencraft.kap_lib.registry.custom.ModSetBonusTypes;
import net.kapitencraft.kap_lib.registry.custom.core.ModRegistryBuilders;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import org.slf4j.Logger;

@Mod(value="kap_lib")
public class KapLibMod {
    public static final String MOD_ID = "kap_lib";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final File MAIN = new File("./kap_lib");
    public static final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();

    public static ResourceLocation res(String sub) {
        return new ResourceLocation(MOD_ID, sub);
    }

    public KapLibMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModRequirementTypes.REGISTRY.register(modEventBus);
        ModSetBonusTypes.REGISTRY.register(modEventBus);
        ModAttributes.REGISTRY.register(modEventBus);
        ModParticleTypes.REGISTRY.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientModConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerModConfig.SPEC);
        MinecraftForge.EVENT_BUS.addListener(CommandHelper::registerClient);
        StartupMessageManager.addModMessage((String)"KapLib Mod loaded");
    }

    public static String doubleFormat(double d) {
        return new DecimalFormat("#.##").format(d);
    }

    public static <T> DeferredRegister<T> registry(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)MOD_ID);
    }

    public static <T> DeferredRegister<T> registry(ResourceKey<Registry<T>> key) {
        return DeferredRegister.create(key, (String)MOD_ID);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerRegistries(NewRegistryEvent event) {
            event.create(ModRegistryBuilders.REQUESTABLES_BUILDER);
            event.create(ModRegistryBuilders.REQUIREMENTS_BUILDER);
            event.create(ModRegistryBuilders.SET_BONUSES);
        }
    }
}

